/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.enchantments.mixin;

import com.devnemo.nemos.enchantments.enchantment.NemosEnchantments;
import com.devnemo.nemos.enchantments.utils.EnchantmentUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={HoeItem.class})
public class HoeItemMixin
extends Item {
    public HoeItemMixin(Item.Properties properties) {
        super(properties);
    }

    public boolean canDestroyBlock(@NotNull ItemStack itemStack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull LivingEntity user) {
        if (!(user instanceof Player)) {
            return super.canDestroyBlock(itemStack, state, level, pos, user);
        }
        ItemStack hoe = user.getMainHandItem();
        Block block = state.getBlock();
        boolean isBlockCropBlock = block instanceof CropBlock;
        if (isBlockCropBlock) {
            boolean hasFarmersKnowledge = EnchantmentUtils.hasEnchantment(level, NemosEnchantments.FARMERS_KNOWLEDGE, hoe);
            boolean isCropRipe = ((CropBlock)block).isMaxAge(state);
            if (hasFarmersKnowledge) {
                return ((Player)user).isCreative() || isCropRipe;
            }
        }
        return true;
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level level, BlockState state, @NotNull BlockPos pos, LivingEntity miner) {
        ItemStack hoe = miner.getMainHandItem();
        boolean isBlockCropBlock = state.getBlock() instanceof CropBlock;
        boolean hasHoeReaperEnchantment = EnchantmentUtils.hasEnchantment(level, NemosEnchantments.REAPER, hoe);
        if (isBlockCropBlock && hasHoeReaperEnchantment) {
            int enchantmentLevel = EnchantmentUtils.getEnchantmentLevel(level, NemosEnchantments.REAPER, hoe);
            int breakingRange = 2 * enchantmentLevel + 1;
            int i = 0;
            while ((double)i < Math.pow(breakingRange, 3.0)) {
                BlockPos nextPos = this.nemosFarming_getNextBlockPos(pos, i, breakingRange);
                this.nemosFarming_breakCrop(level, nextPos, miner);
                ++i;
            }
        }
        return super.mineBlock(stack, level, state, pos, miner);
    }

    @Unique
    private BlockPos nemosFarming_getNextBlockPos(BlockPos pos, int i, int breakingRange) {
        int halfRange = breakingRange / 2;
        int x = i / (breakingRange * breakingRange) - halfRange;
        int y = i / breakingRange % breakingRange - halfRange;
        int z = i % breakingRange - halfRange;
        return pos.offset(x, y, z);
    }

    @Unique
    private void nemosFarming_breakCrop(Level level, BlockPos pos, LivingEntity user) {
        if (!(user instanceof Player)) {
            return;
        }
        BlockState nextBlockState = level.getBlockState(pos);
        Block nextBlock = nextBlockState.getBlock();
        if (nextBlock instanceof CropBlock && this.canDestroyBlock(user.getMainHandItem(), nextBlockState, level, pos, user)) {
            this.nemosFarming_breakBlock(level, nextBlockState, pos, user);
        }
    }

    @Unique
    private void nemosFarming_breakBlock(Level level, BlockState blockState, BlockPos pos, LivingEntity breakingEntity) {
        if (!(blockState.getBlock() instanceof BaseFireBlock)) {
            level.levelEvent(2001, pos, Block.getId((BlockState)blockState));
        }
        BlockEntity blockEntity = blockState.hasBlockEntity() ? level.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)blockState, (Level)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)breakingEntity, (ItemStack)breakingEntity.getMainHandItem());
        if (!EnchantmentUtils.hasEnchantment(level, NemosEnchantments.REPLANTING, breakingEntity.getMainHandItem()) && this.nemosFarming_setBlockState(level, pos)) {
            level.gameEvent((Holder)GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of((Entity)breakingEntity, (BlockState)blockState));
        }
    }

    @Unique
    private boolean nemosFarming_setBlockState(Level level, BlockPos pos) {
        FluidState fluidState = level.getFluidState(pos);
        return level.setBlock(pos, fluidState.createLegacyBlock(), 3, 512);
    }
}

