/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.enchantments.mixin;

import com.devnemo.nemos.enchantments.enchantment.NemosEnchantments;
import com.devnemo.nemos.enchantments.utils.EnchantmentUtils;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Block.class})
public class NeoForgeBlockMixin {
    @ModifyExpressionValue(method={"dropResources(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/Block;getDrops(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/item/ItemStack;)Ljava/util/List;")})
    private static List<ItemStack> handleDrops(List<ItemStack> originalDrops, @Local(argsOnly=true) Level level, @Local(argsOnly=true) ItemStack tool, @Local(argsOnly=true) Entity entity) {
        ServerLevel serverLevel;
        block5: {
            block4: {
                if (!(level instanceof ServerLevel)) break block4;
                serverLevel = (ServerLevel)level;
                if (entity instanceof Player) break block5;
            }
            return originalDrops;
        }
        Player player = (Player)entity;
        boolean hasCollectorEnchantment = EnchantmentUtils.hasEnchantment((Level)serverLevel, NemosEnchantments.COLLECTOR, tool);
        if (!hasCollectorEnchantment) {
            return originalDrops;
        }
        return NeoForgeBlockMixin.nemosEnchantments$getDropsAfterCollecting(originalDrops, player, serverLevel);
    }

    @Unique
    private static List<ItemStack> nemosEnchantments$getDropsAfterCollecting(List<ItemStack> originalDrops, Player player, ServerLevel serverLevel) {
        ArrayList<ItemStack> remainingDrops = new ArrayList<ItemStack>();
        for (ItemStack drop : originalDrops) {
            int originalCount = drop.getCount();
            player.getInventory().add(drop);
            if (drop.getCount() > 0) {
                remainingDrops.add(drop);
            }
            if (originalCount == drop.getCount()) continue;
            float pitch = ((serverLevel.random.nextFloat() - serverLevel.random.nextFloat()) * 0.7f + 1.0f) * 2.0f;
            float volume = 0.2f;
            serverLevel.playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, volume, pitch);
        }
        return remainingDrops;
    }
}

