/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.AdditionalArmoury.entity;

import com.provismet.AdditionalArmoury.items.BoomerangItem;
import com.provismet.AdditionalArmoury.registries.AAEntityTypes;
import com.provismet.AdditionalArmoury.registries.AAItems;
import com.provismet.AdditionalArmoury.utility.AADamageTypes;
import com.provismet.lilylib.interfaces.entity.WorldItemEntity;
import com.provismet.lilylib.util.Relations;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3857;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;

public class BoomerangProjectileEntity
extends class_3857
implements WorldItemEntity {
    private static final String RICOCHET_KEY = "ricochet_count";
    private static final String FLIGHT_TIME_KEY = "flight_time";
    private static final String POWER_KEY = "power";
    private static final String RESETS_COOLDOWN_KEY = "resets_cooldown";
    protected int maxTime = 15;
    protected int flightTime = 0;
    protected int ricochetCount = 1;
    protected float power = 4.0f;
    protected boolean isReturning = false;
    private int ricochetCounterCooldown = 0;
    private boolean resetsCooldown = true;
    private class_1309 previousHit = null;

    public BoomerangProjectileEntity(class_1299<? extends BoomerangProjectileEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public BoomerangProjectileEntity(class_1937 world, @NotNull class_1309 owner, @NotNull class_1799 stack) {
        super(AAEntityTypes.BOOMERANG, owner, world, stack);
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71465(RICOCHET_KEY, this.ricochetCount);
        view.method_71465(FLIGHT_TIME_KEY, this.flightTime);
        view.method_71464(POWER_KEY, this.power);
        view.method_71472(RESETS_COOLDOWN_KEY, this.resetsCooldown);
    }

    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        this.ricochetCount = view.method_71424(RICOCHET_KEY, this.ricochetCount);
        this.flightTime = view.method_71424(FLIGHT_TIME_KEY, this.flightTime);
        this.power = view.method_71423(POWER_KEY, this.power);
        this.resetsCooldown = view.method_71433(RESETS_COOLDOWN_KEY, this.resetsCooldown);
    }

    public void method_5773() {
        if (!this.method_73183().method_8608()) {
            if (this.ricochetCount > 0 && ++this.flightTime >= this.maxTime) {
                this.ricochet(false, true);
            }
            if (this.ricochetCounterCooldown > 0) {
                --this.ricochetCounterCooldown;
            }
        }
        super.method_5773();
        this.method_36456(0.0f);
        this.field_5982 = 0.0f;
        this.method_36457(0.0f);
        this.field_6004 = 0.0f;
    }

    public void method_7485(double x, double y, double z, float speed, float divergence) {
        super.method_7485(x, y, z, speed, divergence);
        this.method_36456(0.0f);
        this.method_36457(0.0f);
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        if (!this.method_73183().method_8608()) {
            if (this.ricochetCount <= 0) {
                this.method_31472();
            } else {
                this.ricochetBlock(blockHitResult.method_17780());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        class_1937 class_19372 = this.method_73183();
        if (!(class_19372 instanceof class_3218)) return;
        class_3218 world = (class_3218)class_19372;
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (entityHitResult.method_17782() == player) {
                if (this.resetsCooldown) {
                    player.method_7357().method_7900(player.method_7357().method_62836(AAItems.BOOMERANG.method_7854()));
                }
                this.method_31472();
                return;
            }
        }
        if (entityHitResult.method_17782() instanceof class_1676) return;
        class_1297 class_12973 = entityHitResult.method_17782();
        if (class_12973 instanceof class_1309) {
            class_1309 target = (class_1309)class_12973;
            class_1282 damageSource = AADamageTypes.BOOMERANG.createDamageSource((class_1297)this, this.method_24921());
            float damage = class_1890.method_60120((class_3218)world, (class_1799)this.method_7495(), (class_1297)target, (class_1282)damageSource, (float)this.getPower());
            target.method_64397(world, damageSource, damage);
            this.applyOnHitEffects(target);
            class_1890.method_60619((class_3218)world, (class_1297)target, (class_1282)damageSource, (class_1799)this.method_7495());
            this.previousHit = target.method_5805() ? target : null;
        }
        if (this.ricochetCount <= 0) return;
        this.ricochet();
    }

    protected boolean ricochet(boolean doFallback, boolean returnToUser) {
        if (this.ricochetCounterCooldown <= 0) {
            this.ricochetCounterCooldown = 2;
            --this.ricochetCount;
        }
        this.flightTime = 0;
        if (this.ricochetCount < 0) {
            this.ricochetCount = 0;
        }
        if ((this.ricochetCount == 0 || returnToUser) && this.method_24921() != null && !this.isReturning) {
            this.isReturning = true;
            class_1297 owner = this.method_24921();
            this.method_7485(owner.method_23317() - this.method_23317(), owner.method_23320() - this.method_23318(), owner.method_23321() - this.method_23321(), 1.0f, 0.5f);
            return true;
        }
        List potentialTargets = this.method_73183().method_8333((class_1297)this, this.method_5829().method_1014(5.0), entity -> {
            if (entity instanceof class_1309) {
                class_1309 target = (class_1309)entity;
                if (target == this.method_24921() || target == this.previousHit || target.method_29504()) {
                    return false;
                }
                class_1297 patt0$temp = this.method_24921();
                if (patt0$temp instanceof class_1309) {
                    class_1309 livingOwner = (class_1309)patt0$temp;
                    return !Relations.isFriendly((class_1309)livingOwner, (class_1309)target);
                }
                return target instanceof class_1588 || target instanceof class_1657;
            }
            return false;
        });
        if (!potentialTargets.isEmpty()) {
            class_1297 target = (class_1297)potentialTargets.get(this.field_5974.method_39332(0, potentialTargets.size() - 1));
            this.method_7485(target.method_23317() - this.method_23317(), target.method_23320() - this.method_23318(), target.method_23321() - this.method_23321(), 1.0f, 0.5f);
            this.isReturning = false;
            return true;
        }
        if (doFallback) {
            this.method_7485(-this.method_18798().method_10216(), -this.method_18798().method_10214(), -this.method_18798().method_10215(), 1.0f, 1.0f);
            this.isReturning = false;
            return true;
        }
        return false;
    }

    protected boolean ricochet() {
        return this.ricochet(true, false);
    }

    protected void ricochetBlock(class_2350 direction) {
        if (!this.ricochet(false, false)) {
            switch (direction) {
                case field_11036: 
                case field_11033: {
                    this.method_7485(this.method_18798().method_10216(), this.method_18798().method_10214() * -1.0, this.method_18798().method_10215(), 1.0f, 0.0f);
                    break;
                }
                case field_11043: 
                case field_11035: {
                    this.method_7485(this.method_18798().method_10216(), this.method_18798().method_10214(), this.method_18798().method_10215() * -1.0, 1.0f, 0.0f);
                    break;
                }
                case field_11034: 
                case field_11039: {
                    this.method_7485(this.method_18798().method_10216() * -1.0, this.method_18798().method_10214(), this.method_18798().method_10215(), 1.0f, 0.0f);
                }
            }
            this.isReturning = false;
        }
    }

    protected void applyOnHitEffects(class_1309 target) {
        class_1792 class_17922 = this.method_7495().method_7909();
        if (class_17922 instanceof BoomerangItem) {
            BoomerangItem boomerang = (BoomerangItem)class_17922;
            class_17922 = this.method_24921();
            if (class_17922 instanceof class_1309) {
                class_1309 livingOwner = (class_1309)class_17922;
                boomerang.applyOnHit(livingOwner, target);
            }
        }
    }

    protected class_1792 method_16942() {
        return AAItems.BOOMERANG;
    }

    protected double method_7490() {
        return 0.005;
    }

    public void setRicochetCount(int value) {
        this.ricochetCount = value;
    }

    public void setCanResetCooldown(boolean value) {
        this.resetsCooldown = value;
    }

    public int getMaxFlightTime() {
        return this.maxTime;
    }

    public void setMaxFlightTime(int value) {
        this.maxTime = value;
    }

    public float getPower() {
        return this.power;
    }

    public void setPower(float value) {
        this.power = value;
    }

    public float getXRotation(float tickDelta) {
        return 90.0f;
    }

    public float getZRotation(float tickDelta) {
        float currentRotation = (float)this.field_6012 * 33.0f;
        float nextRotation = (float)(this.field_6012 + 1) * 33.0f;
        return class_3532.method_16439((float)tickDelta, (float)currentRotation, (float)nextRotation) % 360.0f;
    }

    public float getXOffset(float tickDelta) {
        return -class_3532.method_15362((float)((this.getZRotation(tickDelta) - 15.0f) / 57.295776f)) * 0.25f;
    }

    public float getYOffset(float tickDelta) {
        return this.method_17682() / 2.0f;
    }

    public float getZOffset(float tickDelta) {
        return -class_3532.method_15374((float)((this.getZRotation(tickDelta) - 15.0f) / 57.295776f)) * 0.25f;
    }
}

