/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.datagen.AdditionalArmoury;

import com.provismet.AdditionalArmoury.items.DaggerItem;
import com.provismet.AdditionalArmoury.registries.AAEnchantments;
import com.provismet.AdditionalArmoury.registries.AAEntityTypes;
import com.provismet.AdditionalArmoury.registries.AAItems;
import com.provismet.AdditionalArmoury.registries.AAStatusEffects;
import com.provismet.AdditionalArmoury.utility.AADamageTypes;
import com.provismet.AdditionalArmoury.utility.tags.AAItemTags;
import com.provismet.lilylib.container.DamageTypeContainer;
import com.provismet.lilylib.datagen.provider.LilyLanguageProvider;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1291;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class LanguageGenerator
extends LilyLanguageProvider {
    private static final Map<String, DaggerItem> DAGGER_TRANSLATIONS = Map.of("Wooden Dagger", AAItems.WOODEN_DAGGER, "Stone Dagger", AAItems.STONE_DAGGER, "Golden Dagger", AAItems.GOLDEN_DAGGER, "Iron Dagger", AAItems.IRON_DAGGER, "Diamond Dagger", AAItems.DIAMOND_DAGGER, "Netherite Dagger", AAItems.NETHERITE_DAGGER, "Overnether Dagger", AAItems.OVERNETHER_DAGGER, "Endernether Dagger", AAItems.ENDERNETHER_DAGGER);

    protected LanguageGenerator(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, registryLookup);
    }

    public void generateTranslations(class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        translationBuilder.add("subtitles.additional-armoury.boomerang.throw", "Throws boomerang");
        translationBuilder.add("subtitles.additional-armoury.staff.cast", "Casts spell");
        translationBuilder.add(AAItems.OVERNETHER_INGOT, "Overnether Ingot");
        translationBuilder.add(AAItems.ENDERNETHER_INGOT, "Endernether Ingot");
        translationBuilder.add((class_1792)AAItems.OVERNETHER_BLOCK, "Overnether Block");
        translationBuilder.add((class_1792)AAItems.ENDERNETHER_BLOCK, "Endernether Block");
        translationBuilder.add(AAItems.OVERNETHER_UPGRADE_SMITHING_TEMPLATE, "Overnether Upgrade");
        translationBuilder.add("upgrade.additional-armoury.overnether_upgrade", "Overnether Upgrade");
        translationBuilder.add("item.additional-armoury.overnether_upgrade.ingredients", "Overnether Ingot");
        translationBuilder.add("item.additional-armoury.overnether_upgrade.addition", "Add Overnether Ingot");
        translationBuilder.add(AAItems.ENDERNETHER_UPGRADE_SMITHING_TEMPLATE, "Endernether Upgrade");
        translationBuilder.add("upgrade.additional-armoury.endernether_upgrade", "Endernether Upgrade");
        translationBuilder.add("item.additional-armoury.endernether_upgrade.ingredients", "Endernether Ingot");
        translationBuilder.add("item.additional-armoury.endernether_upgrade.addition", "Add Endernether Ingot");
        translationBuilder.add(AAItems.OVERNETHER_SWORD, "Overnether Sword");
        translationBuilder.add((class_1792)AAItems.OVERNETHER_AXE, "Overnether Axe");
        translationBuilder.add(AAItems.OVERNETHER_PICKAXE, "Overnether Pickaxe");
        translationBuilder.add((class_1792)AAItems.OVERNETHER_SHOVEL, "Overnether Shovel");
        translationBuilder.add((class_1792)AAItems.OVERNETHER_HOE, "Overnether Hoe");
        translationBuilder.add(AAItems.ENDERNETHER_SWORD, "Endernether Sword");
        translationBuilder.add((class_1792)AAItems.ENDERNETHER_AXE, "Endernether Axe");
        translationBuilder.add(AAItems.ENDERNETHER_PICKAXE, "Endernether Pickaxe");
        translationBuilder.add((class_1792)AAItems.ENDERNETHER_SHOVEL, "Endernether Shovel");
        translationBuilder.add((class_1792)AAItems.ENDERNETHER_HOE, "Endernether Hoe");
        translationBuilder.add(AAItems.OVERNETHER_HELMET, "Overnether Helmet");
        translationBuilder.add(AAItems.OVERNETHER_CHESTPLATE, "Overnether Chestplate");
        translationBuilder.add(AAItems.OVERNETHER_LEGGINGS, "Overnether Leggings");
        translationBuilder.add(AAItems.OVERNETHER_BOOTS, "Overnether Boots");
        translationBuilder.add(AAItems.ENDERNETHER_HELMET, "Endernether Helmet");
        translationBuilder.add(AAItems.ENDERNETHER_CHESTPLATE, "Endernether Chestplate");
        translationBuilder.add(AAItems.ENDERNETHER_LEGGINGS, "Endernether Leggings");
        translationBuilder.add(AAItems.ENDERNETHER_BOOTS, "Endernether Boots");
        for (Map.Entry<String, DaggerItem> entry : DAGGER_TRANSLATIONS.entrySet()) {
            LanguageGenerator.addDagger(translationBuilder, entry.getValue(), entry.getKey());
        }
        translationBuilder.add((class_1792)AAItems.WOODEN_MACE, "Wooden Mace");
        translationBuilder.add((class_1792)AAItems.STONE_MACE, "Stone Mace");
        translationBuilder.add((class_1792)AAItems.GOLDEN_MACE, "Golden Mace");
        translationBuilder.add((class_1792)AAItems.IRON_MACE, "Iron Mace");
        translationBuilder.add((class_1792)AAItems.DIAMOND_MACE, "Diamond Mace");
        translationBuilder.add((class_1792)AAItems.NETHERITE_MACE, "Netherite Mace");
        translationBuilder.add((class_1792)AAItems.OVERNETHER_MACE, "Overnether Mace");
        translationBuilder.add((class_1792)AAItems.ENDERNETHER_MACE, "Endernether Mace");
        translationBuilder.add((class_1792)AAItems.STAFF, "Unenchanted Staff");
        translationBuilder.add(AAItems.STAFF.method_7876() + ".enchanted", "Enchanted Staff");
        translationBuilder.add((class_1792)AAItems.BOOMERANG, "Boomerang");
        translationBuilder.add(AAItems.FIREBALL, "Fireball");
        translationBuilder.add(AAItems.FROSTBALL, "Frostball");
        translationBuilder.add(AAItems.GHOSTLY_ORB, "Ghostly Orb");
        translationBuilder.add(AAItems.WIND_TORNADO, "Wind Tornado");
        translationBuilder.add(AAItems.MAGIC_MISSILE, "Magical Missile");
        translationBuilder.add(AAEntityTypes.FIREBALL, "Fireball Spell");
        translationBuilder.add(AAEntityTypes.FROSTBALL, "Frostball Spell");
        translationBuilder.add(AAEntityTypes.GHOSTLY_ORB, "Ghostly Orb Spell");
        translationBuilder.add(AAEntityTypes.WIND_TORNADO, "Wind Tornado Spell");
        translationBuilder.add(AAEntityTypes.MAGIC_MISSILE, "Missile Spell");
        translationBuilder.add(AAEntityTypes.BOOMERANG, "Boomerang");
        translationBuilder.add((class_1291)AAStatusEffects.SHATTERED.comp_349(), "Shattered");
        this.addEnchantment(translationBuilder, AAEnchantments.BOOST, "Boosting", "Launches the user forwards.");
        this.addEnchantment(translationBuilder, AAEnchantments.ERUPTION, "Eruption", "Knockbacks all nearby enemies.");
        this.addEnchantment(translationBuilder, AAEnchantments.JUMP, "Soaring", "Launch into the air and gain slow-fall.");
        this.addEnchantment(translationBuilder, AAEnchantments.FIREBALL, "Fireball", "Shoot a fireball that burns on hit.");
        this.addEnchantment(translationBuilder, AAEnchantments.FROSTBALL, "Frostball", "Shoot a frostball that freezes on hit.");
        this.addEnchantment(translationBuilder, AAEnchantments.GHOSTLY_ORB, "Ghostly Orb", "Shoot a spectral ball that passes through blocks.");
        this.addEnchantment(translationBuilder, AAEnchantments.GALE, "Gale", "Shoot a barrage of tornados that launch targets.");
        this.addEnchantment(translationBuilder, AAEnchantments.MAGIC_MISSILE, "Missile", "Shoot a magical missile that follows enemies.");
        this.addEnchantment(translationBuilder, AAEnchantments.EXPLOSION, "Bakuretsu Mahou", "Casts the most powerful of artillery magic.");
        this.addEnchantment(translationBuilder, AAEnchantments.ADHESIVE, "Adhesive", "Potion-tipped daggers have unlimited uses.");
        this.addEnchantment(translationBuilder, AAEnchantments.SPLATTER, "Splatter", "Potion-tipped daggers affect multiple targets at once.");
        this.addEnchantment(translationBuilder, AAEnchantments.SHREDDING, "Shredding", "Increases the duration of the shattered effect from a mace.");
        this.addEnchantment(translationBuilder, AAEnchantments.DISMANTLE, "Dismantling", "Increases damage dealt to armor from maces.");
        this.addEnchantment(translationBuilder, AAEnchantments.RICOCHET, "Ricochet", "Increases the number of boomerang bounces.");
        this.addEnchantment(translationBuilder, AAEnchantments.MULTITHROW, "MultiThrow", "Throws 3 boomerangs at once.");
        this.addEnchantment(translationBuilder, AAEnchantments.FAR_THROW, "Discus", "Increases boomerang maximum distance.");
        this.addEnchantment(translationBuilder, AAEnchantments.STRONG_THROW, "Strong Arm", "Increases boomerang damage.");
        LanguageGenerator.addAttackDeathMessage(translationBuilder, AADamageTypes.FIREBALL, "was blasted by");
        LanguageGenerator.addAttackDeathMessage(translationBuilder, AADamageTypes.FROSTBALL, "was frozen by");
        LanguageGenerator.addAttackDeathMessage(translationBuilder, AADamageTypes.ERUPTION, "was launched by");
        LanguageGenerator.addAttackDeathMessage(translationBuilder, AADamageTypes.GHOSTLY_ORB, "was haunted by");
        LanguageGenerator.addAttackDeathMessage(translationBuilder, AADamageTypes.WIND_TORNADO, "was caught in a tornado from");
        LanguageGenerator.addAttackDeathMessage(translationBuilder, AADamageTypes.MAGIC_MISSILE, "could not outrun the magic of");
        LanguageGenerator.addAttackDeathMessage(translationBuilder, AADamageTypes.BOOMERANG, "was struck by a boomerang from");
        translationBuilder.add("tooltip.additional-armoury.dagger_uses", "Remaining Splashes: %1$s");
        LanguageGenerator.addAdvancement(translationBuilder, "enchant_staff", "Magic Caster", "Enchant a Staff");
        LanguageGenerator.addAdvancement(translationBuilder, "archwizard", "Arch-Wizard", "Cast the most powerful magic");
        LanguageGenerator.addAdvancement(translationBuilder, "tipped_dagger", "Rogue-Like", "Craft a potion-tipped Dagger");
        LanguageGenerator.addAdvancement(translationBuilder, "overnether", "I Am Listening", "Get a full suit of Overnether armor");
        LanguageGenerator.addAdvancement(translationBuilder, "endernether", "Part Of The Chorus", "Get a full suit of Endernether armor");
        translationBuilder.add(AAItemTags.DAGGERS, "Daggers");
        translationBuilder.add(AAItemTags.DAGGER_ENCHANTABLE, "Dagger Enchantable");
        translationBuilder.add(AAItemTags.MACES, "Maces");
        translationBuilder.add(AAItemTags.MACE_ENCHANTABLE, "Mace Enchantable");
        translationBuilder.add(AAItemTags.BOOMERANG_ENCHANTABLE, "Boomerang Enchantable");
        translationBuilder.add(AAItemTags.STAFF_ENCHANTABLE, "Staff Enchantable");
    }

    public static void addDagger(FabricLanguageProvider.TranslationBuilder translationBuilder, DaggerItem dagger, String basename) {
        translationBuilder.add((class_1792)dagger, basename);
        for (class_1842 potion : class_7923.field_41179.method_29722().stream().map(Map.Entry::getValue).toList()) {
            class_6880 potionEntry = class_7923.field_41179.method_47983((Object)potion);
            if (potionEntry.method_40230().isEmpty()) continue;
            String effectKey = dagger.method_7876() + ".effect." + ((class_5321)potionEntry.method_40230().get()).method_29177().method_12832();
            String potionBasename = LanguageGenerator.titleCase(potion.method_63990().replace('_', ' '));
            try {
                if (potionEntry != class_1847.field_8999 && potionEntry != class_1847.field_8967 && potionEntry != class_1847.field_8985 && !((class_1842)potionEntry.comp_349()).method_8049().isEmpty()) {
                    translationBuilder.add(effectKey, potionBasename + "-Tipped " + basename);
                    continue;
                }
                if (potionEntry == class_1847.field_8991) {
                    translationBuilder.add(effectKey, "Wet " + basename);
                    continue;
                }
                translationBuilder.add(effectKey, basename);
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    public static void addPotionEntriesForDaggers(FabricLanguageProvider.TranslationBuilder translationBuilder, class_6880<class_1842> potion, String potionPrefix) {
        if (potion.method_40230().isEmpty()) {
            throw new RuntimeException("Cannot add potion to daggers because key is empty.");
        }
        for (Map.Entry<String, DaggerItem> entry : DAGGER_TRANSLATIONS.entrySet()) {
            String effectKey = entry.getValue().method_7876() + ".effect." + ((class_5321)potion.method_40230().get()).method_29177().method_12832();
            translationBuilder.add(effectKey, potionPrefix + entry.getKey());
        }
    }

    private static String titleCase(String string) {
        String[] words = string.split(" ");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            for (int j = 0; j < word.length(); ++j) {
                char character = word.charAt(j);
                if (j == 0) {
                    builder.append(Character.toUpperCase(character));
                    continue;
                }
                builder.append(Character.toLowerCase(character));
            }
            if (i >= words.length - 1) continue;
            builder.append(" ");
        }
        return builder.toString();
    }

    private static void addAttackDeathMessage(FabricLanguageProvider.TranslationBuilder translationBuilder, DamageTypeContainer container, String message) {
        translationBuilder.add(container.getTranslationKey(), "%1$s " + message + " %2$s");
        translationBuilder.add(container.getTranslationKey("item"), "%1$s " + message + " %2$s using %3$s");
    }

    public static void addAdvancement(FabricLanguageProvider.TranslationBuilder translationBuilder, String name, String title, String description) {
        translationBuilder.add("advancement.additional-armoury." + name + ".title", title);
        translationBuilder.add("advancement.additional-armoury." + name + ".description", description);
    }
}

