/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.caffeine.cache;

import bending.libraries.caffeine.cache.AsyncCacheLoader;
import bending.libraries.caffeine.cache.Caffeine;
import bending.libraries.caffeine.cache.Expiry;
import bending.libraries.caffeine.cache.LocalCacheFactory;
import bending.libraries.caffeine.cache.Pacer;
import bending.libraries.caffeine.cache.SIMW;
import bending.libraries.caffeine.cache.Scheduler;
import bending.libraries.caffeine.cache.Ticker;
import bending.libraries.caffeine.cache.TimerWheel;

class SIMWA<K, V>
extends SIMW<K, V> {
    static final LocalCacheFactory FACTORY = SIMWA::new;
    final Ticker ticker;
    final Expiry<K, V> expiry;
    final TimerWheel<K, V> timerWheel;
    volatile long expiresAfterAccessNanos;
    final Pacer pacer;

    SIMWA(Caffeine<K, V> caffeine, AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.expiry = caffeine.getExpiry(this.isAsync);
        this.timerWheel = caffeine.expiresVariable() ? new TimerWheel() : null;
        this.expiresAfterAccessNanos = caffeine.getExpiresAfterAccessNanos();
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final boolean expiresVariable() {
        return this.timerWheel != null;
    }

    @Override
    public final Expiry<K, V> expiry() {
        return this.expiry;
    }

    @Override
    protected final TimerWheel<K, V> timerWheel() {
        return this.timerWheel;
    }

    @Override
    protected final boolean expiresAfterAccess() {
        return this.timerWheel == null;
    }

    @Override
    protected final long expiresAfterAccessNanos() {
        return this.expiresAfterAccessNanos;
    }

    @Override
    protected final void setExpiresAfterAccessNanos(long l) {
        this.expiresAfterAccessNanos = l;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

