/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core;

import bending.libraries.flywaydb.core.ProgressLogger;
import bending.libraries.flywaydb.core.ProgressModel;
import bending.libraries.flywaydb.core.api.logging.Log;
import bending.libraries.flywaydb.core.api.logging.LogFactory;
import bending.libraries.jackson.databind.json.JsonMapper;
import lombok.Generated;

public class ProgressLoggerJson
implements ProgressLogger {
    @Generated
    private static final Log LOG = LogFactory.getLog(ProgressLoggerJson.class);
    private final ProgressModel progressModel = new ProgressModel();
    private final JsonMapper jsonMapper = new JsonMapper();

    @Override
    public ProgressLogger subTask(String operationName) {
        return new ProgressLoggerJson(this.progressModel.getOperation() + "." + operationName);
    }

    public ProgressLoggerJson(String operationName) {
        this.progressModel.setOperation(operationName);
    }

    @Override
    public void log(String message) {
        this.progressModel.setMessage(message);
        System.err.println(this.jsonMapper.writeValueAsString(this.progressModel));
        this.progressModel.setStepAndTotal(this.progressModel.getStep() + 1);
    }

    @Override
    public void log(String message, int step) {
        this.progressModel.setMessage(message);
        this.progressModel.setStepAndTotal(step);
        System.err.println(this.jsonMapper.writeValueAsString(this.progressModel));
    }

    @Override
    public ProgressLogger pushSteps(int steps) {
        this.progressModel.setTotalSteps(this.progressModel.getTotalSteps() == null ? steps : steps + this.progressModel.getTotalSteps());
        return this;
    }
}

