/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.api;

import bending.libraries.flywaydb.core.internal.scanner.LocationParser;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public final class Location
implements Comparable<Location> {
    private static final String CLASSPATH_PREFIX = "classpath:";
    @Deprecated
    public static final String FILESYSTEM_PREFIX = "filesystem:";
    private static final String AWS_S3_PREFIX = "s3:";
    private static final String GCS_PREFIX = "gcs:";
    private final String prefix;
    private final String rawPath;
    private final String rootPath;
    private final Pattern pathRegex;

    public static Location fromPath(String prefix, String path) {
        return new Location(prefix, path, path, null);
    }

    public static Location fromWildcardPath(String prefix, String rootPath, String wildcardPath, Pattern pathRegex) {
        return new Location(prefix, rootPath, wildcardPath, pathRegex);
    }

    @Deprecated
    public Location(String descriptor) {
        Location location = LocationParser.parseLocation(descriptor);
        this.rawPath = location.rawPath;
        this.rootPath = location.rootPath;
        this.prefix = location.prefix;
        this.pathRegex = location.pathRegex;
    }

    private Location(String prefix, String rootPath, String rawPath, Pattern pathRegex) {
        this.rawPath = rawPath;
        this.rootPath = rootPath;
        this.prefix = prefix;
        this.pathRegex = pathRegex;
    }

    @Deprecated
    public boolean matchesPath(String path) {
        if (this.pathRegex == null) {
            return true;
        }
        return this.pathRegex.matcher(path).matches();
    }

    public String getPathRelativeToThis(String path) {
        String relPath;
        Matcher matcher;
        if (this.pathRegex != null && this.pathRegex.pattern().contains("?<relpath>") && (matcher = this.pathRegex.matcher(path)).matches() && (relPath = matcher.group("relpath")) != null && !relPath.isEmpty()) {
            return relPath;
        }
        return !this.rootPath.isEmpty() ? path.substring(this.rootPath.length() + 1) : path;
    }

    @Deprecated
    public boolean isClassPath() {
        return CLASSPATH_PREFIX.equals(this.prefix);
    }

    @Deprecated
    public boolean isFileSystem() {
        return FILESYSTEM_PREFIX.equals(this.prefix);
    }

    @Deprecated
    public boolean isAwsS3() {
        return AWS_S3_PREFIX.equals(this.prefix);
    }

    @Deprecated
    public boolean isGCS() {
        return GCS_PREFIX.equals(this.prefix);
    }

    @Deprecated
    public boolean isParentOf(Location other) {
        if (this.pathRegex != null || other.pathRegex != null) {
            return false;
        }
        if (CLASSPATH_PREFIX.equals(this.prefix) && CLASSPATH_PREFIX.equals(other.prefix)) {
            return (other.getDescriptor() + "/").startsWith(this.getDescriptor() + "/");
        }
        if (FILESYSTEM_PREFIX.equals(this.prefix) && FILESYSTEM_PREFIX.equals(other.prefix)) {
            return (other.getDescriptor() + File.separator).startsWith(this.getDescriptor() + File.separator);
        }
        return false;
    }

    @Deprecated
    public String getPath() {
        return this.rawPath;
    }

    public String getDescriptor() {
        return this.prefix + this.rawPath;
    }

    @Override
    public int compareTo(Location o) {
        return this.getDescriptor().compareTo(o.getDescriptor());
    }

    public String toString() {
        return this.getDescriptor();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location other = (Location)o;
        String this$$getDescriptor = this.getDescriptor();
        String other$$getDescriptor = other.getDescriptor();
        return !(this$$getDescriptor == null ? other$$getDescriptor != null : !this$$getDescriptor.equals(other$$getDescriptor));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $$getDescriptor = this.getDescriptor();
        result = result * 59 + ($$getDescriptor == null ? 43 : $$getDescriptor.hashCode());
        return result;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public String getRootPath() {
        return this.rootPath;
    }

    @Generated
    public Pattern getPathRegex() {
        return this.pathRegex;
    }
}

