/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.api.migration.baseline;

import bending.libraries.flywaydb.core.api.FlywayException;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.api.migration.BaseJavaMigration;
import bending.libraries.flywaydb.core.api.migration.baseline.BaselineMigrationType;
import bending.libraries.flywaydb.core.api.migration.baseline.BaselineResolvedMigration;
import bending.libraries.flywaydb.core.api.resolver.ResolvedMigration;
import bending.libraries.flywaydb.core.extensibility.MigrationType;
import bending.libraries.flywaydb.core.internal.jdbc.StatementInterceptor;
import bending.libraries.flywaydb.core.internal.resolver.java.JavaMigrationExecutor;
import bending.libraries.flywaydb.core.internal.util.ClassUtils;

public abstract class BaselineJavaMigration
extends BaseJavaMigration {
    private static final String BASELINE_MIGRATION_PREFIX = "B";

    @Override
    protected void init() {
        String shortName = this.getClass().getSimpleName();
        if (!shortName.startsWith(BASELINE_MIGRATION_PREFIX)) {
            throw new FlywayException("Invalid baseline Java migration class name: " + this.getClass().getName() + " => ensure it starts with B or implement org.flywaydb.core.api.migration.JavaMigration directly for non-default naming");
        }
        this.extractVersionAndDescription(shortName, BASELINE_MIGRATION_PREFIX, false);
    }

    @Override
    public MigrationType getType() {
        return BaselineMigrationType.JDBC_BASELINE;
    }

    @Override
    public ResolvedMigration getResolvedMigration(Configuration config, StatementInterceptor statementInterceptor) {
        return new BaselineResolvedMigration(this.getVersion(), this.getDescription(), this.getClass().getName(), this.getChecksum(), null, this.getType(), ClassUtils.getLocationOnDisk(this.getClass()), new JavaMigrationExecutor(this, statementInterceptor), config);
    }
}

