/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.api.migration.baseline;

import bending.libraries.flywaydb.core.api.ResourceProvider;
import bending.libraries.flywaydb.core.api.callback.Event;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.api.logging.Log;
import bending.libraries.flywaydb.core.api.logging.LogFactory;
import bending.libraries.flywaydb.core.api.migration.baseline.BaselineMigrationConfigurationExtension;
import bending.libraries.flywaydb.core.api.migration.baseline.BaselineMigrationType;
import bending.libraries.flywaydb.core.api.migration.baseline.BaselineResolvedMigration;
import bending.libraries.flywaydb.core.api.resolver.MigrationResolver;
import bending.libraries.flywaydb.core.api.resolver.ResolvedMigration;
import bending.libraries.flywaydb.core.api.resource.LoadableResource;
import bending.libraries.flywaydb.core.api.resource.Resource;
import bending.libraries.flywaydb.core.extensibility.MigrationType;
import bending.libraries.flywaydb.core.internal.resolver.ChecksumCalculator;
import bending.libraries.flywaydb.core.internal.resolver.ResolvedMigrationComparator;
import bending.libraries.flywaydb.core.internal.resolver.sql.SqlMigrationExecutor;
import bending.libraries.flywaydb.core.internal.resource.ResourceName;
import bending.libraries.flywaydb.core.internal.resource.ResourceNameParser;
import bending.libraries.flywaydb.core.internal.sqlscript.SqlScript;
import bending.libraries.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import bending.libraries.flywaydb.core.internal.sqlscript.SqlScriptFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import lombok.Generated;

public class BaselineMigrationResolver
implements MigrationResolver {
    @Generated
    private static final Log LOG = LogFactory.getLog(BaselineMigrationResolver.class);

    protected static boolean isSqlCallback(ResourceName result) {
        return Event.fromId(result.getPrefix()) != null;
    }

    @Override
    public Collection<ResolvedMigration> resolveMigrations(MigrationResolver.Context context) {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        BaselineMigrationConfigurationExtension configurationExtension = context.configuration.getPluginRegister().getExact(BaselineMigrationConfigurationExtension.class);
        Configuration configuration = context.configuration;
        this.addMigrations(migrations, configurationExtension.getBaselineMigrationPrefix(), configuration, context.resourceProvider, context.sqlScriptFactory, context.sqlScriptExecutorFactory);
        migrations.sort(new ResolvedMigrationComparator());
        return migrations;
    }

    @Override
    public MigrationType getDefaultMigrationType() {
        return BaselineMigrationType.SQL_BASELINE;
    }

    @Override
    public String getPrefix(Configuration configuration) {
        return configuration.getPluginRegister().getExact(BaselineMigrationConfigurationExtension.class).getBaselineMigrationPrefix();
    }

    private void addMigrations(List<ResolvedMigration> migrations, String prefix, Configuration configuration, ResourceProvider resourceProvider, SqlScriptFactory sqlScriptFactory, SqlScriptExecutorFactory sqlScriptExecutorFactory) {
        ResourceNameParser resourceNameParser = new ResourceNameParser(configuration);
        for (LoadableResource resource : resourceProvider.getResources(prefix, configuration.getSqlMigrationSuffixes())) {
            String filename = resource.getFilename();
            ResourceName result = resourceNameParser.parse(filename);
            if (!result.isValid() || BaselineMigrationResolver.isSqlCallback(result) || !prefix.equals(result.getPrefix())) continue;
            SqlScript sqlScript = sqlScriptFactory.createSqlScript(resource, configuration.isMixed(), resourceProvider);
            ArrayList<LoadableResource> resources = new ArrayList<LoadableResource>();
            resources.add(resource);
            TreeSet<LoadableResource> referencedResources = new TreeSet<LoadableResource>();
            for (SqlScript referencedSqlScript : sqlScript.getReferencedSqlScripts()) {
                referencedResources.add(referencedSqlScript.getResource());
            }
            if (!referencedResources.isEmpty()) {
                LOG.debug("Calculating checksum for '" + filename + "' using the following referenced scripts: " + referencedResources.stream().map(Resource::getFilename).collect(Collectors.joining(",")));
            }
            resources.addAll(referencedResources);
            Integer checksum = this.getChecksumForLoadableResource(resources);
            migrations.add(new BaselineResolvedMigration(result.getVersion(), result.getDescription(), resource.getRelativePath(), checksum, null, resource.getAbsolutePathOnDisk(), new SqlMigrationExecutor(sqlScriptExecutorFactory, sqlScript, false, configuration.isBatch()), configuration));
        }
    }

    private Integer getChecksumForLoadableResource(List<LoadableResource> loadableResources) {
        return ChecksumCalculator.calculate((LoadableResource[])loadableResources.toArray(LoadableResource[]::new));
    }
}

