/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.api.migration.baseline;

import bending.libraries.flywaydb.core.api.MigrationState;
import bending.libraries.flywaydb.core.api.MigrationVersion;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.api.executor.MigrationExecutor;
import bending.libraries.flywaydb.core.api.migration.baseline.BaselineMigrationType;
import bending.libraries.flywaydb.core.api.resolver.ResolvedMigration;
import bending.libraries.flywaydb.core.extensibility.MigrationType;
import bending.libraries.flywaydb.core.internal.info.MigrationInfoContext;
import bending.libraries.flywaydb.core.internal.resolver.ResolvedMigrationImpl;

public class BaselineResolvedMigration
extends ResolvedMigrationImpl {
    public BaselineResolvedMigration(MigrationVersion version, String description, String script, Integer checksum, Integer equivalentChecksum, String physicalLocation, MigrationExecutor executor, Configuration config) {
        this(version, description, script, checksum, equivalentChecksum, BaselineMigrationType.SQL_BASELINE, physicalLocation, executor, config);
    }

    public BaselineResolvedMigration(MigrationVersion version, String description, String script, Integer checksum, Integer equivalentChecksum, MigrationType migrationType, String physicalLocation, MigrationExecutor executor, Configuration config) {
        super(version, description, script, checksum, equivalentChecksum, migrationType, physicalLocation, executor);
    }

    @Override
    public boolean canCompareWith(ResolvedMigration o) {
        return o instanceof BaselineResolvedMigration;
    }

    @Override
    public MigrationState getState(MigrationInfoContext context) {
        MigrationState migrationState = super.getState(context);
        if (migrationState == MigrationState.PENDING && this.migrationsAppliedOrBaselineExists(context)) {
            return MigrationState.IGNORED;
        }
        if (migrationState == MigrationState.BASELINE_IGNORED && this.getVersion().equals(context.pendingBaseline)) {
            if (this.migrationsAppliedOrBaselineExists(context)) {
                return MigrationState.BASELINE_IGNORED;
            }
            return MigrationState.PENDING;
        }
        return migrationState;
    }

    private boolean migrationsAppliedOrBaselineExists(MigrationInfoContext context) {
        return context.appliedBaseline != null || context.lastApplied != MigrationVersion.EMPTY;
    }
}

