/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.api.output;

import bending.libraries.flywaydb.core.api.output.MigrateErrorResult;
import bending.libraries.flywaydb.core.api.output.OperationResult;
import bending.libraries.flywaydb.core.api.output.errors.ErrorOutputItem;
import bending.libraries.flywaydb.core.api.output.errors.ExceptionToErrorObjectConverter;
import bending.libraries.flywaydb.core.api.output.errors.FaultToErrorObjectConverter;
import bending.libraries.flywaydb.core.api.output.errors.FlywayExceptionToErrorObjectConverter;
import bending.libraries.flywaydb.core.api.output.errors.FlywayMigrateExceptionToErrorObjectConverter;
import bending.libraries.flywaydb.core.api.output.errors.FlywaySqlExceptionToErrorObjectConverter;
import bending.libraries.flywaydb.core.internal.exception.FlywayMigrateException;
import java.util.Collection;
import java.util.List;

public record ErrorOutput(ErrorOutputItem error) implements OperationResult
{
    private static final Collection<ExceptionToErrorObjectConverter<? extends Exception, ? extends ErrorOutputItem>> ERROR_OBJECT_CONVERTERS = List.of(new FlywayMigrateExceptionToErrorObjectConverter(), new FlywaySqlExceptionToErrorObjectConverter(), new FlywayExceptionToErrorObjectConverter());

    public static ErrorOutput fromException(Exception exception) {
        ExceptionToErrorObjectConverter converter = ERROR_OBJECT_CONVERTERS.stream().filter(x -> x.getSupportedExceptionType().isInstance(exception)).findFirst().orElse(new FaultToErrorObjectConverter());
        return new ErrorOutput((ErrorOutputItem)ErrorOutput.convertException(converter, exception));
    }

    public static MigrateErrorResult fromMigrateException(FlywayMigrateException exception) {
        return exception.getErrorResult();
    }

    public static OperationResult toOperationResult(Exception exception) {
        if (exception instanceof FlywayMigrateException) {
            return ErrorOutput.fromMigrateException((FlywayMigrateException)exception);
        }
        return ErrorOutput.fromException(exception);
    }

    private static <E extends Exception, T extends ErrorOutputItem> T convertException(ExceptionToErrorObjectConverter<E, T> converter, Exception exception) {
        return converter.convert((Exception)converter.getSupportedExceptionType().cast(exception));
    }
}

