/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.api.output.errors;

import bending.libraries.flywaydb.core.api.output.errors.ErrorCause;
import bending.libraries.flywaydb.core.api.output.errors.ErrorOutputItem;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public abstract class ExceptionToErrorObjectConverter<E extends Exception, T extends ErrorOutputItem> {
    public abstract Class<E> getSupportedExceptionType();

    public abstract T convert(E var1);

    String getStackTrace(Throwable exception) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)output, true, StandardCharsets.UTF_8);
        exception.printStackTrace(printStream);
        return output.toString(StandardCharsets.UTF_8);
    }

    Optional<ErrorCause> getCause(Throwable e) {
        return Optional.ofNullable(e.getCause()).map(cause -> new ErrorCause(cause.getMessage(), this.getStackTrace((Throwable)cause), this.getCause((Throwable)cause).orElse(null)));
    }
}

