/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.api.resolver;

import bending.libraries.flywaydb.core.api.MigrationState;
import bending.libraries.flywaydb.core.api.MigrationVersion;
import bending.libraries.flywaydb.core.api.executor.MigrationExecutor;
import bending.libraries.flywaydb.core.api.resolver.ChecksumMatcher;
import bending.libraries.flywaydb.core.extensibility.MigrationType;
import bending.libraries.flywaydb.core.internal.info.MigrationInfoContext;

public interface ResolvedMigration
extends ChecksumMatcher {
    public MigrationVersion getVersion();

    default public boolean isVersioned() {
        return this.getVersion() != null;
    }

    public String getDescription();

    public String getScript();

    public Integer getChecksum();

    public MigrationType getType();

    public String getPhysicalLocation();

    public MigrationExecutor getExecutor();

    default public MigrationState getState(MigrationInfoContext context) {
        if (this.getVersion() != null) {
            if (this.getVersion().compareTo(context.lastApplied == MigrationVersion.EMPTY ? context.pendingBaseline : context.appliedBaseline) < 0) {
                return MigrationState.BELOW_BASELINE;
            }
            if (this.getVersion().compareTo(context.lastApplied == MigrationVersion.EMPTY ? context.pendingBaseline : context.appliedBaseline) == 0) {
                return MigrationState.BASELINE_IGNORED;
            }
            if (context.target != null && context.target != MigrationVersion.NEXT && this.getVersion().compareTo(context.target) > 0) {
                return MigrationState.ABOVE_TARGET;
            }
            if (this.getVersion().compareTo(context.lastApplied) < 0 && !context.outOfOrder) {
                return MigrationState.IGNORED;
            }
        }
        return MigrationState.PENDING;
    }

    default public boolean canCompareWith(ResolvedMigration o) {
        return true;
    }
}

