/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.api.resource;

import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.api.resource.Resource;
import bending.libraries.flywaydb.core.internal.parser.ParsingContext;
import bending.libraries.flywaydb.core.internal.parser.PlaceholderReplacingReader;
import java.io.Reader;

public abstract class LoadableResource
implements Resource,
Comparable<LoadableResource> {
    public abstract Reader read();

    public boolean shouldStream() {
        return false;
    }

    @Override
    public int compareTo(LoadableResource o) {
        return this.getRelativePath().compareTo(o.getRelativePath());
    }

    public static LoadableResource createPlaceholderReplacingLoadableResource(final LoadableResource loadableResource, final Configuration configuration, final ParsingContext parsingContext) {
        return new LoadableResource(){

            @Override
            public Reader read() {
                return PlaceholderReplacingReader.create(configuration, parsingContext, loadableResource.read());
            }

            @Override
            public String getAbsolutePath() {
                return loadableResource.getAbsolutePath();
            }

            @Override
            public String getAbsolutePathOnDisk() {
                return loadableResource.getAbsolutePathOnDisk();
            }

            @Override
            public String getFilename() {
                return loadableResource.getFilename();
            }

            @Override
            public String getRelativePath() {
                return loadableResource.getRelativePath();
            }
        };
    }
}

