/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.callback;

import bending.libraries.flywaydb.core.api.FlywayException;
import bending.libraries.flywaydb.core.api.ResourceProvider;
import bending.libraries.flywaydb.core.api.callback.CallbackEvent;
import bending.libraries.flywaydb.core.api.callback.Context;
import bending.libraries.flywaydb.core.api.callback.GenericCallback;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.api.logging.Log;
import bending.libraries.flywaydb.core.api.logging.LogFactory;
import bending.libraries.flywaydb.core.api.resource.LoadableResource;
import bending.libraries.flywaydb.core.internal.resource.ResourceName;
import bending.libraries.flywaydb.core.internal.resource.ResourceNameParser;
import bending.libraries.flywaydb.core.internal.sqlscript.SqlScript;
import bending.libraries.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import bending.libraries.flywaydb.core.internal.sqlscript.SqlScriptFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class SqlScriptCallbackFactory<E extends CallbackEvent<E>> {
    @Generated
    private static final Log LOG = LogFactory.getLog(SqlScriptCallbackFactory.class);
    private final List<SqlScriptCallback<E>> callbacks = new ArrayList<SqlScriptCallback<E>>();

    public SqlScriptCallbackFactory(ResourceProvider resourceProvider, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, Configuration configuration, ParseCallbackEvent<E> parseCallbackEvent) {
        HashMap<String, SqlScript> callbacksFound = new HashMap<String, SqlScript>();
        LOG.debug("Scanning for SQL callbacks ...");
        Collection<LoadableResource> resources = resourceProvider.getResources("", configuration.getSqlMigrationSuffixes());
        ResourceNameParser resourceNameParser = new ResourceNameParser(configuration);
        for (LoadableResource resource : resources) {
            ResourceName parsedName = resourceNameParser.parse(resource.getFilename());
            if (!parsedName.isValid()) continue;
            String name = parsedName.getFilenameWithoutSuffix();
            Optional<E> maybeEvent = parseCallbackEvent.parse(parsedName.getPrefix());
            if (!maybeEvent.isPresent()) continue;
            SqlScript existing = (SqlScript)callbacksFound.get(name);
            if (existing != null) {
                throw new FlywayException("Found more than 1 SQL callback script called " + name + "!\nOffenders:\n-> " + existing.getResource().getAbsolutePathOnDisk() + "\n-> " + resource.getAbsolutePathOnDisk());
            }
            SqlScript sqlScript = sqlScriptFactory.createSqlScript(resource, configuration.isMixed(), resourceProvider);
            callbacksFound.put(name, sqlScript);
            boolean batch = configuration.isBatch();
            this.callbacks.add(new SqlScriptCallback<CallbackEvent>((CallbackEvent)maybeEvent.get(), parsedName.getDescription(), sqlScriptExecutorFactory, sqlScript, batch));
        }
        Collections.sort(this.callbacks);
    }

    public List<GenericCallback<E>> getCallbacks() {
        return new ArrayList<GenericCallback<E>>(this.callbacks);
    }

    @FunctionalInterface
    public static interface ParseCallbackEvent<E extends CallbackEvent<E>> {
        public Optional<E> parse(String var1);
    }

    private static class SqlScriptCallback<E extends CallbackEvent<E>>
    implements GenericCallback<E>,
    Comparable<SqlScriptCallback<E>> {
        private final E event;
        private final String description;
        private final SqlScriptExecutorFactory sqlScriptExecutorFactory;
        private final SqlScript sqlScript;
        private final boolean batch;

        @Override
        public boolean supports(E event, Context context) {
            return this.event == event;
        }

        @Override
        public boolean canHandleInTransaction(E event, Context context) {
            return this.sqlScript.executeInTransaction();
        }

        @Override
        public void handle(E event, Context context) {
            if (!this.sqlScript.shouldExecute()) {
                LOG.debug("Not executing SQL callback: " + event.getId() + (String)(this.description == null ? "" : " - " + this.description));
                return;
            }
            LOG.info("Executing SQL callback: " + event.getId() + (String)(this.description == null ? "" : " - " + this.description) + (this.sqlScript.executeInTransaction() ? "" : " [non-transactional]"));
            boolean outputQueryResults = context.getConfiguration().isOutputQueryResults();
            this.sqlScriptExecutorFactory.createSqlScriptExecutor(context.getConnection(), false, this.batch, outputQueryResults).execute(this.sqlScript, context.getConfiguration());
        }

        @Override
        public String getCallbackName() {
            return this.description;
        }

        @Override
        public int compareTo(SqlScriptCallback<E> o) {
            int result = this.event.compareTo(o.event);
            if (result == 0) {
                if (this.description == null) {
                    return -1;
                }
                if (o.description == null) {
                    return 1;
                }
                result = this.description.compareTo(o.description);
            }
            return result;
        }

        @Generated
        private SqlScriptCallback(E event, String description, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScript sqlScript, boolean batch) {
            this.event = event;
            this.description = description;
            this.sqlScriptExecutorFactory = sqlScriptExecutorFactory;
            this.sqlScript = sqlScript;
            this.batch = batch;
        }
    }
}

