/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.command;

import bending.libraries.flywaydb.core.api.FlywayException;
import bending.libraries.flywaydb.core.api.callback.Event;
import bending.libraries.flywaydb.core.api.logging.Log;
import bending.libraries.flywaydb.core.api.logging.LogFactory;
import bending.libraries.flywaydb.core.internal.callback.CallbackExecutor;
import bending.libraries.flywaydb.core.internal.database.base.Connection;
import bending.libraries.flywaydb.core.internal.database.base.Database;
import bending.libraries.flywaydb.core.internal.database.base.Schema;
import bending.libraries.flywaydb.core.internal.jdbc.ExecutionTemplateFactory;
import bending.libraries.flywaydb.core.internal.schemahistory.SchemaHistory;
import java.util.ArrayList;
import lombok.Generated;

public class DbSchemas {
    @Generated
    private static final Log LOG = LogFactory.getLog(DbSchemas.class);
    private final Connection connection;
    private final Schema[] schemas;
    private final SchemaHistory schemaHistory;
    private final Database database;
    private final CallbackExecutor<Event> callbackExecutor;

    public DbSchemas(Database database, Schema[] schemas, SchemaHistory schemaHistory, CallbackExecutor callbackExecutor) {
        this.database = database;
        this.connection = database.getMainConnection();
        this.schemas = schemas;
        this.schemaHistory = schemaHistory;
        this.callbackExecutor = callbackExecutor;
    }

    public void create(boolean baseline) {
        this.callbackExecutor.onEvent(Event.CREATE_SCHEMA);
        this.callbackExecutor.onEvent(Event.BEFORE_CREATE_SCHEMA);
        int retries = 0;
        while (true) {
            try {
                ExecutionTemplateFactory.createExecutionTemplate(this.connection.getJdbcConnection(), this.database).execute(() -> {
                    ArrayList<Schema> createdSchemas = new ArrayList<Schema>();
                    for (Schema schema : this.schemas) {
                        if (!schema.exists()) {
                            if (schema.getName() == null) {
                                throw new FlywayException("Unable to determine schema for the schema history table. Set a default schema for the connection or specify one using the defaultSchema property!");
                            }
                            LOG.debug("Creating schema: " + String.valueOf(schema));
                            schema.create();
                            createdSchemas.add(schema);
                            continue;
                        }
                        LOG.debug("Skipping creation of existing schema: " + String.valueOf(schema));
                    }
                    if (!createdSchemas.isEmpty()) {
                        this.schemaHistory.create(baseline);
                        this.schemaHistory.addSchemasMarker((Schema[])createdSchemas.toArray(Schema[]::new));
                    }
                    return null;
                });
                return;
            }
            catch (RuntimeException e) {
                if (++retries >= 10) {
                    throw e;
                }
                try {
                    LOG.debug("Schema creation failed. Retrying in 1 sec ...");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }
}

