/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.command.clean;

import bending.libraries.flywaydb.core.api.FlywayException;
import bending.libraries.flywaydb.core.api.callback.Event;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.api.logging.Log;
import bending.libraries.flywaydb.core.api.logging.LogFactory;
import bending.libraries.flywaydb.core.api.output.CleanResult;
import bending.libraries.flywaydb.core.api.output.CommandResultFactory;
import bending.libraries.flywaydb.core.extensibility.CommandExtension;
import bending.libraries.flywaydb.core.internal.callback.CallbackExecutor;
import bending.libraries.flywaydb.core.internal.command.clean.CleanExecutor;
import bending.libraries.flywaydb.core.internal.command.clean.CleanModeConfigurationExtension;
import bending.libraries.flywaydb.core.internal.configuration.ConfigUtils;
import bending.libraries.flywaydb.core.internal.database.base.Connection;
import bending.libraries.flywaydb.core.internal.database.base.Database;
import bending.libraries.flywaydb.core.internal.database.base.Schema;
import bending.libraries.flywaydb.core.internal.schemahistory.SchemaHistory;
import bending.libraries.flywaydb.core.internal.util.StringUtils;
import java.util.Collections;
import lombok.Generated;

public class DbClean {
    @Generated
    private static final Log LOG = LogFactory.getLog(DbClean.class);
    private final SchemaHistory schemaHistory;
    protected final Schema defaultSchema;
    protected final Schema[] schemas;
    protected final Connection connection;
    protected final Database database;
    protected final CallbackExecutor<Event> callbackExecutor;
    protected final Configuration configuration;

    public DbClean(Database database, SchemaHistory schemaHistory, Schema defaultSchema, Schema[] schemas, CallbackExecutor<Event> callbackExecutor, Configuration configuration) {
        this.schemaHistory = schemaHistory;
        this.defaultSchema = defaultSchema;
        this.schemas = schemas;
        this.connection = database.getMainConnection();
        this.database = database;
        this.callbackExecutor = callbackExecutor;
        this.configuration = configuration;
    }

    public CleanResult clean() throws FlywayException {
        CleanResult cleanResult;
        if (this.configuration.isCleanDisabled()) {
            throw new FlywayException("Unable to execute clean as it has been disabled with the 'flyway.cleanDisabled' property.");
        }
        this.callbackExecutor.onEvent(Event.BEFORE_CLEAN);
        String command = DbClean.toCommand(ConfigUtils.getCleanModel(this.configuration).getMode());
        if ("clean".equals(command)) {
            cleanResult = CommandResultFactory.createCleanResult(this.database.getCatalog());
            new CleanExecutor(this.connection, this.database, this.schemaHistory, this.callbackExecutor).clean(this.defaultSchema, this.schemas, cleanResult);
        } else {
            cleanResult = this.configuration.getPluginRegister().getInstancesOf(CommandExtension.class).stream().filter(e -> e.handlesCommand(command)).findFirst().map(e -> (CleanResult)e.handle(command, this.configuration, Collections.emptyList())).orElseThrow(() -> new FlywayException("No command extension found to handle command " + command));
        }
        this.callbackExecutor.onEvent(Event.AFTER_CLEAN);
        this.schemaHistory.clearCache();
        return cleanResult;
    }

    public static String toCommand(String mode) {
        if (!StringUtils.hasText(mode)) {
            return "clean";
        }
        try {
            return switch (CleanModeConfigurationExtension.Mode.valueOf(mode.toUpperCase())) {
                case CleanModeConfigurationExtension.Mode.SCHEMA -> "clean-schemas";
                case CleanModeConfigurationExtension.Mode.ALL -> "clean-all";
                default -> "clean";
            };
        }
        catch (IllegalArgumentException e) {
            return mode;
        }
    }
}

