/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.configuration.resolvers;

import bending.libraries.flywaydb.core.FlywayTelemetryManager;
import bending.libraries.flywaydb.core.ProgressLogger;
import bending.libraries.flywaydb.core.api.CoreErrorCode;
import bending.libraries.flywaydb.core.api.FlywayException;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.extensibility.ConfigurationExtension;
import bending.libraries.flywaydb.core.internal.configuration.models.ConfigurationModel;
import bending.libraries.flywaydb.core.internal.configuration.models.EnvironmentModel;
import bending.libraries.flywaydb.core.internal.configuration.resolvers.PropertyResolver;
import bending.libraries.flywaydb.core.internal.configuration.resolvers.PropertyResolverContext;
import bending.libraries.flywaydb.core.internal.configuration.resolvers.ProvisionerConfiguration;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyResolverContextImpl
implements PropertyResolverContext {
    private final Map<String, PropertyResolver> resolvers;
    private final Map<String, ConfigurationExtension> resolverConfigurations;
    private final String environmentName;
    private final Configuration configuration;
    private static final CharsetEncoder ASCII_ENCODER = StandardCharsets.US_ASCII.newEncoder();
    private static final Pattern NESTED_RESOLVER_PATTERN = Pattern.compile("(^|[^$])\\$\\{(([^}]+|)\\$\\{.+?}).*?}");
    private static final Pattern RESOLVER_REGEX_PATTERN = Pattern.compile("\\${1,2}\\{[^.]+\\.[^.]+?\\}");
    private static final Pattern VERBATIM_REGEX_PATTERN = Pattern.compile("\\!\\{.*\\}");

    public PropertyResolverContextImpl(String environmentName, Configuration configuration, Map<String, PropertyResolver> resolvers, Map<String, ConfigurationExtension> resolverConfigurations) {
        this.environmentName = environmentName;
        this.configuration = PropertyResolverContextImpl.createConfigurationCopy(configuration, environmentName);
        this.resolvers = resolvers;
        this.resolverConfigurations = Optional.ofNullable(resolverConfigurations).orElseGet(Map::of);
    }

    @Override
    public ConfigurationExtension getResolverConfiguration(String resolverName) {
        return this.resolverConfigurations.get(resolverName);
    }

    @Override
    public ConfigurationExtension getResolverConfigurationOrThrow(String resolverName) {
        return Optional.ofNullable(this.getResolverConfiguration(resolverName)).orElseThrow(() -> new FlywayException("Required configuration not defined for resolver/provisioner \"" + resolverName + "\" for environment " + this.environmentName, CoreErrorCode.CONFIGURATION));
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public FlywayTelemetryManager getTelemetryManager() {
        return this.configuration.getPluginRegister().getInstanceOf(FlywayTelemetryManager.class);
    }

    @Override
    public String getWorkingDirectory() {
        String workingDirectory = this.configuration.getWorkingDirectory();
        if (workingDirectory == null) {
            return System.getProperty("user.dir");
        }
        return workingDirectory;
    }

    @Override
    public String getEnvironmentName() {
        return this.environmentName;
    }

    @Override
    public String resolveValue(String value, ProgressLogger progress) {
        if (value == null) {
            return null;
        }
        if (this.isVerbatim(value)) {
            return value.substring(2, value.length() - 1);
        }
        if (PropertyResolverContextImpl.hasNestedResolvers(value)) {
            throw new FlywayException("Resolvers cannot be nested: " + value, CoreErrorCode.CONFIGURATION);
        }
        return RESOLVER_REGEX_PATTERN.matcher(value.strip()).replaceAll(m -> this.getPropertyResolverReplacement((MatchResult)m, progress));
    }

    @Override
    public String resolveValueOrThrow(String input, ProgressLogger progress, String propertyName) {
        String result = this.resolveValue(input, progress);
        if (result == null) {
            throw new FlywayException("Configuration value " + propertyName + " not specified for environment " + this.environmentName, CoreErrorCode.CONFIGURATION);
        }
        return result;
    }

    @Override
    public List<String> resolveValues(List<String> input, ProgressLogger progress) {
        if (input == null) {
            return null;
        }
        return input.stream().map(v -> this.resolveValue((String)v, progress)).toList();
    }

    @Override
    public List<String> resolveValuesOrThrow(List<String> input, ProgressLogger progress, String propertyName) {
        List<String> result = this.resolveValues(input, progress);
        if (result == null) {
            throw new FlywayException("Configuration value " + propertyName + " not specified for environment " + this.environmentName, CoreErrorCode.CONFIGURATION);
        }
        return result;
    }

    private boolean isVerbatim(String value) {
        return VERBATIM_REGEX_PATTERN.matcher(value.strip()).matches();
    }

    private String getPropertyResolverReplacement(MatchResult resolverMatchResult, ProgressLogger progress) {
        return this.parsePropertyResolver(resolverMatchResult, progress).replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\\\$");
    }

    private String parsePropertyResolver(MatchResult resolverMatchResult, ProgressLogger progress) {
        String resolverMatch = resolverMatchResult.group();
        if (resolverMatch.startsWith("$$")) {
            return resolverMatch.substring(1);
        }
        String resolverName = resolverMatch.substring(2, resolverMatch.indexOf(".")).strip();
        if (!this.resolvers.containsKey(resolverName)) {
            throw new FlywayException("Unknown resolver '" + resolverName + "' for environment " + this.environmentName, CoreErrorCode.CONFIGURATION);
        }
        if (resolverMatch.contains(":")) {
            String resolverParam = resolverMatch.substring(resolverMatch.indexOf(".") + 1, resolverMatch.indexOf(":")).strip();
            String filter = resolverMatch.substring(resolverMatch.indexOf(":") + 1, resolverMatch.length() - 1).strip();
            return PropertyResolverContextImpl.filter(this.resolvers.get(resolverName).resolve(resolverParam, this, progress), filter);
        }
        String resolverParam = resolverMatch.substring(resolverMatch.indexOf(".") + 1, resolverMatch.length() - 1).strip();
        return this.resolvers.get(resolverName).resolve(resolverParam, this, progress);
    }

    static String filter(String str, String filter) {
        return str.chars().filter(c -> PropertyResolverContextImpl.isAllowed((char)c, filter)).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private static boolean isAllowed(char c, String filter) {
        return filter.contains("D") && Character.isDigit(c) || filter.contains("A") && Character.isLetter(c) || filter.contains("a") && Character.isLetter(c) && ASCII_ENCODER.canEncode(c) || filter.contains("d") && Character.isDigit(c) && ASCII_ENCODER.canEncode(c);
    }

    private static boolean hasNestedResolvers(String value) {
        Matcher matcher = NESTED_RESOLVER_PATTERN.matcher(value);
        while (matcher.find()) {
            if (!RESOLVER_REGEX_PATTERN.matcher(matcher.group(2)).find()) continue;
            return true;
        }
        return false;
    }

    private static Configuration createConfigurationCopy(Configuration configuration, String environmentName) {
        EnvironmentModel environmentModel = Optional.ofNullable(configuration).map(Configuration::getModernConfig).map(ConfigurationModel::getEnvironments).map(envs -> (EnvironmentModel)envs.get(environmentName)).orElseThrow(() -> new FlywayException("Unable to provision environment " + environmentName + " as required configuration is not defined", CoreErrorCode.CONFIGURATION));
        return ProvisionerConfiguration.createConfigurationWithEnvironment(configuration, environmentName, environmentModel);
    }
}

