/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.configuration.resolvers;

import bending.libraries.flywaydb.core.api.CoreErrorCode;
import bending.libraries.flywaydb.core.api.FlywayException;
import bending.libraries.flywaydb.core.api.configuration.ClassicConfiguration;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.internal.configuration.models.ConfigurationModel;
import bending.libraries.flywaydb.core.internal.configuration.models.EnvironmentModel;
import bending.libraries.flywaydb.core.internal.configuration.models.ResolvedEnvironment;
import bending.libraries.flywaydb.core.internal.configuration.resolvers.PropertyResolverContext;
import bending.libraries.flywaydb.core.internal.configuration.resolvers.ProvisionerMode;
import java.util.Map;

public class ProvisionerConfiguration {
    public static void requireDryRunUnsetForProvision(PropertyResolverContext context) {
        if (context.getConfiguration().getDryRunOutput() != null) {
            throw new FlywayException("Provisioning " + context.getEnvironmentName() + " would alter the environment or have side effects, so is not supported with dry run enabled.", CoreErrorCode.CONFIGURATION);
        }
    }

    public static void requireDryRunUnsetForReprovision(PropertyResolverContext context) {
        if (context.getConfiguration().getDryRunOutput() != null) {
            throw new FlywayException("Reprovisioning " + context.getEnvironmentName() + " would alter the environment or have side effects, so is not supported with dry run enabled.", CoreErrorCode.CONFIGURATION);
        }
    }

    public static ClassicConfiguration createConfigurationWithEnvironment(Configuration configuration, String environmentName, EnvironmentModel environmentModel) {
        ConfigurationModel newConfigurationModel = ConfigurationModel.clone(configuration.getModernConfig());
        ClassicConfiguration newConfiguration = new ClassicConfiguration(newConfigurationModel);
        newConfiguration.setAllEnvironments(Map.of(environmentName, environmentModel));
        newConfiguration.setEnvironment(environmentName);
        newConfiguration.setProvisionMode(ProvisionerMode.Skip);
        newConfiguration.setCallbacks(configuration.getCallbacks());
        newConfiguration.setPluginRegister(configuration.getPluginRegister().getCopy());
        newConfiguration.setWorkingDirectory(configuration.getWorkingDirectory());
        return newConfiguration;
    }

    public static ClassicConfiguration createConfigurationWithEnvironment(PropertyResolverContext context, ResolvedEnvironment resolvedEnvironment) {
        return ProvisionerConfiguration.createConfigurationWithEnvironment(context.getConfiguration(), context.getEnvironmentName(), resolvedEnvironment.toEnvironmentModel());
    }

    public static ClassicConfiguration createConfigurationWithEnvironment(PropertyResolverContext context, EnvironmentModel environmentModel) {
        return ProvisionerConfiguration.createConfigurationWithEnvironment(context.getConfiguration(), context.getEnvironmentName(), environmentModel);
    }
}

