/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.configuration.resolvers;

import bending.libraries.flywaydb.core.api.FlywayException;
import java.util.Arrays;
import lombok.Generated;

public enum ProvisionerMode {
    Provision("provision"),
    Reprovision("reprovision"),
    Skip("skip");

    private final String value;

    public static ProvisionerMode fromString(String value) {
        return Arrays.stream(ProvisionerMode.values()).filter(mode -> mode.value.equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new FlywayException("Unknown provisioner mode: " + value));
    }

    public boolean isHigherPriorityThan(ProvisionerMode other) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case Reprovision -> {
                if (other != Reprovision) {
                    yield true;
                }
                yield false;
            }
            case Provision -> {
                if (other == Skip) {
                    yield true;
                }
                yield false;
            }
            case Skip -> false;
        };
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    private ProvisionerMode(String value) {
        this.value = value;
    }
}

