/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.database.base;

import bending.libraries.flywaydb.core.internal.database.base.Database;
import bending.libraries.flywaydb.core.internal.database.base.Schema;
import bending.libraries.flywaydb.core.internal.database.base.Table;
import bending.libraries.flywaydb.core.internal.exception.FlywaySqlException;
import bending.libraries.flywaydb.core.internal.jdbc.ExecutionTemplateFactory;
import bending.libraries.flywaydb.core.internal.jdbc.JdbcTemplate;
import bending.libraries.flywaydb.core.internal.jdbc.JdbcUtils;
import java.io.Closeable;
import java.sql.SQLException;
import java.util.concurrent.Callable;

public abstract class Connection<D extends Database>
implements Closeable {
    protected final D database;
    protected JdbcTemplate jdbcTemplate;
    private final java.sql.Connection jdbcConnection;
    protected final String originalSchemaNameOrSearchPath;
    private final boolean originalAutoCommit;

    protected Connection(D database, java.sql.Connection connection) {
        this.database = database;
        try {
            this.originalAutoCommit = connection.getAutoCommit();
            if (!this.originalAutoCommit) {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to turn on auto-commit for the connection", e);
        }
        this.jdbcConnection = connection;
        this.jdbcTemplate = new JdbcTemplate(this.jdbcConnection, ((Database)database).getDatabaseType());
        try {
            this.originalSchemaNameOrSearchPath = this.getCurrentSchemaNameOrSearchPath();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine the original schema for the connection", e);
        }
    }

    protected abstract String getCurrentSchemaNameOrSearchPath() throws SQLException;

    public final Schema getCurrentSchema() {
        try {
            return this.doGetCurrentSchema();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine the current schema for the connection", e);
        }
    }

    protected Schema doGetCurrentSchema() throws SQLException {
        return this.getSchema(this.getCurrentSchemaNameOrSearchPath());
    }

    public abstract Schema getSchema(String var1);

    public void changeCurrentSchemaTo(Schema schema) {
        try {
            if (!schema.exists()) {
                return;
            }
            this.doChangeCurrentSchemaOrSearchPathTo(schema.getName());
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error setting current schema to " + String.valueOf(schema), e);
        }
    }

    protected void doChangeCurrentSchemaOrSearchPathTo(String schemaNameOrSearchPath) throws SQLException {
    }

    public <T> T lock(Table table, Callable<T> callable) {
        return ExecutionTemplateFactory.createTableExclusiveExecutionTemplate(this.jdbcTemplate.getConnection(), table, this.database).execute(callable);
    }

    public final JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public final void close() {
        this.restoreOriginalState();
        this.restoreOriginalSchema();
        this.restoreOriginalAutoCommit();
        JdbcUtils.closeConnection(this.jdbcConnection);
    }

    private void restoreOriginalSchema() {
        ExecutionTemplateFactory.createExecutionTemplate(this.jdbcConnection, this.database).execute(() -> {
            try {
                this.doChangeCurrentSchemaOrSearchPathTo(this.originalSchemaNameOrSearchPath);
            }
            catch (SQLException e) {
                throw new FlywaySqlException("Unable to restore original schema", e);
            }
            return null;
        });
    }

    public final void restoreOriginalState() {
        try {
            this.doRestoreOriginalState();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to restore connection to its original state", e);
        }
    }

    private void restoreOriginalAutoCommit() {
        try {
            this.jdbcConnection.setAutoCommit(this.originalAutoCommit);
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to restore connection to its original auto-commit setting", e);
        }
    }

    protected void doRestoreOriginalState() throws SQLException {
    }

    public final java.sql.Connection getJdbcConnection() {
        return this.jdbcConnection;
    }
}

