/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.database.base;

import bending.libraries.flywaydb.core.api.CoreMigrationType;
import bending.libraries.flywaydb.core.api.MigrationVersion;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.api.logging.Log;
import bending.libraries.flywaydb.core.api.logging.LogFactory;
import bending.libraries.flywaydb.core.extensibility.LicenseGuard;
import bending.libraries.flywaydb.core.extensibility.Tier;
import bending.libraries.flywaydb.core.internal.database.DatabaseType;
import bending.libraries.flywaydb.core.internal.database.base.Connection;
import bending.libraries.flywaydb.core.internal.database.base.DatabaseConstants;
import bending.libraries.flywaydb.core.internal.database.base.Schema;
import bending.libraries.flywaydb.core.internal.database.base.Table;
import bending.libraries.flywaydb.core.internal.exception.FlywayDbUpgradeRequiredException;
import bending.libraries.flywaydb.core.internal.exception.FlywaySqlException;
import bending.libraries.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import bending.libraries.flywaydb.core.internal.jdbc.JdbcTemplate;
import bending.libraries.flywaydb.core.internal.jdbc.JdbcUtils;
import bending.libraries.flywaydb.core.internal.jdbc.StatementInterceptor;
import bending.libraries.flywaydb.core.internal.resource.StringResource;
import bending.libraries.flywaydb.core.internal.sqlscript.Delimiter;
import bending.libraries.flywaydb.core.internal.sqlscript.SqlScript;
import bending.libraries.flywaydb.core.internal.sqlscript.SqlScriptFactory;
import bending.libraries.flywaydb.core.internal.util.AbbreviationUtils;
import bending.libraries.flywaydb.core.internal.util.Pair;
import bending.libraries.flywaydb.core.internal.util.StringUtils;
import java.io.Closeable;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import lombok.Generated;

public abstract class Database<C extends Connection>
implements Closeable {
    @Generated
    private static final Log LOG = LogFactory.getLog(Database.class);
    protected final DatabaseType databaseType;
    protected final Configuration configuration;
    protected final StatementInterceptor statementInterceptor;
    protected final JdbcConnectionFactory jdbcConnectionFactory;
    protected final DatabaseMetaData jdbcMetaData;
    protected final java.sql.Connection rawMainJdbcConnection;
    protected JdbcTemplate jdbcTemplate;
    private C migrationConnection;
    private C eventConnection;
    private C mainConnection;
    private MigrationVersion version;
    private String installedBy;

    public Database(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        this.databaseType = jdbcConnectionFactory.getDatabaseType();
        this.configuration = configuration;
        this.rawMainJdbcConnection = jdbcConnectionFactory.openConnection();
        try {
            this.jdbcMetaData = this.rawMainJdbcConnection.getMetaData();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to get metadata for connection", e);
        }
        this.jdbcTemplate = new JdbcTemplate(this.rawMainJdbcConnection, this.databaseType);
        this.jdbcConnectionFactory = jdbcConnectionFactory;
        this.statementInterceptor = statementInterceptor;
    }

    private C getConnection(java.sql.Connection connection) {
        return this.doGetConnection(connection);
    }

    protected abstract C doGetConnection(java.sql.Connection var1);

    public abstract void ensureSupported(Configuration var1);

    public final MigrationVersion getVersion() {
        if (this.version == null) {
            this.version = this.determineVersion();
        }
        return this.version;
    }

    protected final void ensureDatabaseIsRecentEnough(String oldestSupportedVersion) {
        if (!this.getVersion().isAtLeast(oldestSupportedVersion)) {
            throw new FlywayDbUpgradeRequiredException(this.databaseType, this.computeVersionDisplayName(this.getVersion()), this.computeVersionDisplayName(MigrationVersion.fromVersion(oldestSupportedVersion)));
        }
    }

    protected final void ensureDatabaseNotOlderThanOtherwiseRecommendUpgradeToFlywayEdition(String oldestSupportedVersionInThisEdition, List<Tier> editionWhereStillSupported, Configuration configuration) {
        if (!LicenseGuard.isLicensed(configuration, editionWhereStillSupported) && !this.getVersion().isAtLeast(oldestSupportedVersionInThisEdition)) {
            LOG.info(this.getDatabaseType().getName() + " " + this.computeVersionDisplayName(this.getVersion()) + " is outside of Redgate community support. See https://rd.gt/468B6ni for details");
        }
    }

    protected final void recommendFlywayUpgradeIfNecessary(String newestSupportedVersion) {
        if (this.getVersion().isNewerThan(newestSupportedVersion)) {
            this.recommendFlywayUpgrade(newestSupportedVersion);
        }
    }

    protected final void recommendFlywayUpgradeIfNecessaryForMajorVersion(String newestSupportedVersion) {
        if (this.getVersion().isMajorNewerThan(newestSupportedVersion)) {
            this.recommendFlywayUpgrade(newestSupportedVersion);
        }
    }

    protected final void notifyDatabaseIsNotFormallySupported() {
        LOG.warn("Support for " + String.valueOf(this.databaseType) + " is provided only on a community-led basis, and is not formally supported by Redgate");
    }

    private void recommendFlywayUpgrade(String newestSupportedVersion) {
        String message = "Using " + String.valueOf(this.databaseType) + " " + this.computeVersionDisplayName(this.getVersion()) + " which is newer than the version Flyway has been verified with. The latest verified version of " + String.valueOf(this.databaseType) + " is " + newestSupportedVersion + ".";
        LOG.warn(message);
    }

    protected String computeVersionDisplayName(MigrationVersion version) {
        return version.getVersion();
    }

    public Delimiter getDefaultDelimiter() {
        return Delimiter.SEMICOLON;
    }

    public final String getCatalog() {
        try {
            return this.doGetCatalog();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error retrieving the database name", e);
        }
    }

    protected String doGetCatalog() throws SQLException {
        return ((Connection)this.getMainConnection()).getJdbcConnection().getCatalog();
    }

    public final String getCurrentUser() {
        try {
            return this.doGetCurrentUser();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error retrieving the database user", e);
        }
    }

    protected String doGetCurrentUser() throws SQLException {
        return this.jdbcMetaData.getUserName();
    }

    public abstract boolean supportsDdlTransactions();

    public abstract String getBooleanTrue();

    public abstract String getBooleanFalse();

    public final String quote(String ... identifiers) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String identifier : identifiers) {
            if (!first) {
                result.append(".");
            }
            first = false;
            result.append(this.doQuote(identifier));
        }
        return result.toString();
    }

    public String doQuote(String identifier) {
        return this.getOpenQuote() + identifier + this.getCloseQuote();
    }

    protected String getOpenQuote() {
        return "\"";
    }

    protected String getCloseQuote() {
        return "\"";
    }

    protected String getEscapedQuote() {
        return "";
    }

    public String unQuote(String identifier) {
        String open = this.getOpenQuote();
        String close = this.getCloseQuote();
        if (!open.equals("") && !close.equals("") && identifier.startsWith(open) && identifier.endsWith(close)) {
            identifier = identifier.substring(open.length(), identifier.length() - close.length());
            if (!this.getEscapedQuote().equals("")) {
                identifier = StringUtils.replaceAll(identifier, this.getEscapedQuote(), close);
            }
        }
        return identifier;
    }

    public abstract boolean catalogIsSchema();

    public boolean useSingleConnection() {
        return false;
    }

    public DatabaseMetaData getJdbcMetaData() {
        return this.jdbcMetaData;
    }

    public final C getMainConnection() {
        if (this.mainConnection == null) {
            this.mainConnection = this.getConnection(this.rawMainJdbcConnection);
        }
        return this.mainConnection;
    }

    public final C getMigrationConnection() {
        if (this.migrationConnection == null) {
            this.migrationConnection = this.useSingleConnection() ? this.getMainConnection() : this.getConnection(this.jdbcConnectionFactory.openConnection());
        }
        return this.migrationConnection;
    }

    public final C getEventConnection() {
        if (!this.hasEventConnection()) {
            this.eventConnection = this.getConnection(this.jdbcConnectionFactory.openConnection());
        }
        return this.eventConnection;
    }

    public final boolean hasEventConnection() {
        return this.eventConnection != null;
    }

    public void disposeEventConnection() {
        if (this.hasEventConnection()) {
            ((Connection)this.eventConnection).close();
            this.eventConnection = null;
        }
    }

    protected MigrationVersion determineVersion() {
        try {
            return MigrationVersion.fromVersion(this.jdbcMetaData.getDatabaseMajorVersion() + "." + this.jdbcMetaData.getDatabaseMinorVersion());
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine the major version of the database", e);
        }
    }

    public final SqlScript getCreateScript(SqlScriptFactory sqlScriptFactory, Table table, boolean baseline) {
        return sqlScriptFactory.createSqlScript(new StringResource(this.getRawCreateScript(table, baseline)), false, null);
    }

    public abstract String getRawCreateScript(Table var1, boolean var2);

    public String getInsertStatement(Table table) {
        return "INSERT INTO " + String.valueOf(table) + " (" + this.quote("installed_rank") + ", " + this.quote("version") + ", " + this.quote("description") + ", " + this.quote("type") + ", " + this.quote("script") + ", " + this.quote("checksum") + ", " + this.quote("installed_by") + ", " + this.quote("execution_time") + ", " + this.quote("success") + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    public String getUpdateStatement(Table table) {
        return "UPDATE " + String.valueOf(table) + " SET " + this.quote("description") + "=? , " + this.quote("type") + "=? , " + this.quote("checksum") + "=? WHERE " + this.quote("installed_rank") + "=?";
    }

    protected String getBaselineStatement(Table table) {
        return String.format(this.getInsertStatement(table).replace("?", "%s"), 1, "'" + String.valueOf(this.configuration.getBaselineVersion()) + "'", "'" + AbbreviationUtils.abbreviateDescription(this.configuration.getBaselineDescription()) + "'", "'" + String.valueOf(CoreMigrationType.BASELINE) + "'", "'" + AbbreviationUtils.abbreviateScript(this.configuration.getBaselineDescription()) + "'", "NULL", "'" + this.getInstalledBy() + "'", 0, this.getBooleanTrue());
    }

    public String getSelectStatement(Table table) {
        return "SELECT " + this.quote("installed_rank") + "," + this.quote("version") + "," + this.quote("description") + "," + this.quote("type") + "," + this.quote("script") + "," + this.quote("checksum") + "," + this.quote("installed_on") + "," + this.quote("installed_by") + "," + this.quote("execution_time") + "," + this.quote("success") + " FROM " + String.valueOf(table) + " WHERE " + this.quote("installed_rank") + " > ? ORDER BY " + this.quote("installed_rank");
    }

    public Pair<String, Object> getDeleteStatement(Table table, boolean version, String filter) {
        String deleteStatement = "DELETE FROM " + String.valueOf(table) + " WHERE " + this.quote("success") + " = " + this.getBooleanFalse() + " AND " + (version ? this.quote("version") + " = ?" : this.quote("description") + " = ?");
        return Pair.of(deleteStatement, filter);
    }

    public final String getInstalledBy() {
        if (this.installedBy == null) {
            this.installedBy = this.configuration.getInstalledBy() == null ? this.getCurrentUser() : this.configuration.getInstalledBy();
        }
        return this.installedBy;
    }

    @Override
    public void close() {
        if (!this.useSingleConnection() && this.migrationConnection != null) {
            ((Connection)this.migrationConnection).close();
        }
        if (this.mainConnection != null) {
            ((Connection)this.mainConnection).close();
        }
        this.disposeEventConnection();
        if (this.rawMainJdbcConnection != null) {
            JdbcUtils.closeConnection(this.rawMainJdbcConnection);
        }
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public boolean supportsEmptyMigrationDescription() {
        return true;
    }

    public boolean supportsMultiStatementTransactions() {
        return true;
    }

    public void cleanPreSchemas() {
        try {
            this.doCleanPreSchemas();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to clean database " + String.valueOf(this), e);
        }
    }

    protected void doCleanPreSchemas() throws SQLException {
    }

    public void cleanPostSchemas(Schema[] schemas) {
        try {
            this.doCleanPostSchemas(schemas);
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to clean schema " + String.valueOf(this), e);
        }
    }

    protected void doCleanPostSchemas(Schema[] schemas) throws SQLException {
    }

    public Schema[] getAllSchemas() {
        throw new UnsupportedOperationException("Getting all schemas not supported for " + this.getDatabaseType().getName());
    }

    public String getDatabaseHosting() {
        String url = this.configuration.getUrl();
        if (DatabaseConstants.DATABASE_HOSTING_AZURE_URL_IDENTIFIER.matcher(url).find()) {
            return "azure-vm";
        }
        if (DatabaseConstants.DATABASE_HOSTING_EC2_URL_IDENTIFIER.matcher(url).find()) {
            return "aws-vm";
        }
        if (url.contains("socketFactory=com.google.cloud")) {
            return "gcp-vm";
        }
        return "local";
    }

    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }
}

