/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.database.h2;

import bending.libraries.flywaydb.core.api.MigrationVersion;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.internal.database.base.Database;
import bending.libraries.flywaydb.core.internal.database.base.Schema;
import bending.libraries.flywaydb.core.internal.database.base.Table;
import bending.libraries.flywaydb.core.internal.database.h2.H2Connection;
import bending.libraries.flywaydb.core.internal.exception.FlywaySqlException;
import bending.libraries.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import bending.libraries.flywaydb.core.internal.jdbc.StatementInterceptor;
import java.sql.Connection;
import java.sql.SQLException;

public class H2Database
extends Database<H2Connection> {
    private static final String DEFAULT_USER = "<< default user >>";
    private static final String DUMMY_SCRIPT_NAME = "<< history table creation script >>";
    boolean supportsDropSchemaCascade;
    private boolean requiresV2MetadataColumnNames = super.determineVersion().isAtLeast("2.0.0");
    CompatibilityMode compatibilityMode = this.determineCompatibilityMode();

    public H2Database(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    @Override
    protected H2Connection doGetConnection(Connection connection) {
        return new H2Connection(this, connection, this.requiresV2MetadataColumnNames);
    }

    @Override
    protected MigrationVersion determineVersion() {
        String query = this.requiresV2MetadataColumnNames ? "SELECT SETTING_VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE SETTING_NAME = 'info.BUILD_ID'" : "SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME = 'info.BUILD_ID'";
        try {
            int buildId = ((H2Connection)this.getMainConnection()).getJdbcTemplate().queryForInt(query, new String[0]);
            return MigrationVersion.fromVersion(super.determineVersion().getVersion() + "." + buildId);
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine H2 build ID", e);
        }
    }

    private CompatibilityMode determineCompatibilityMode() {
        String query = this.requiresV2MetadataColumnNames ? "SELECT SETTING_VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE SETTING_NAME = 'MODE'" : "SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME = 'MODE'";
        try {
            String mode = ((H2Connection)this.getMainConnection()).getJdbcTemplate().queryForString(query, new String[0]);
            if (mode == null || "".equals(mode)) {
                return CompatibilityMode.REGULAR;
            }
            return CompatibilityMode.valueOf(mode);
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine H2 compatibility mode", e);
        }
    }

    @Override
    public void ensureSupported(Configuration configuration) {
        this.ensureDatabaseIsRecentEnough("1.2.137");
        this.recommendFlywayUpgradeIfNecessary("2.3.232");
        this.supportsDropSchemaCascade = this.getVersion().isAtLeast("1.4.200");
    }

    @Override
    public String getRawCreateScript(Table table, boolean baseline) {
        String script = this.compatibilityMode == CompatibilityMode.Oracle ? DUMMY_SCRIPT_NAME : "";
        return "CREATE TABLE IF NOT EXISTS " + String.valueOf(table) + " (\n    \"installed_rank\" INT NOT NULL,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INT,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,\n    \"execution_time\" INT NOT NULL,\n    \"success\" BOOLEAN NOT NULL,\n    CONSTRAINT \"" + table.getName() + "_pk\" PRIMARY KEY (\"installed_rank\")\n) AS SELECT -1, NULL, '<< Flyway Schema History table created >>', 'TABLE', '" + script + "', NULL, '" + this.getInstalledBy() + "', CURRENT_TIMESTAMP, 0, TRUE;\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "") + "CREATE INDEX \"" + ((Schema)table.getSchema()).getName() + "\".\"" + table.getName() + "_s_idx\" ON " + String.valueOf(table) + " (\"success\");";
    }

    @Override
    public String getSelectStatement(Table table) {
        return "SELECT " + this.quote("installed_rank") + "," + this.quote("version") + "," + this.quote("description") + "," + this.quote("type") + "," + this.quote("script") + "," + this.quote("checksum") + "," + this.quote("installed_on") + "," + this.quote("installed_by") + "," + this.quote("execution_time") + "," + this.quote("success") + " FROM " + String.valueOf(table) + " WHERE " + this.quote("type") + " != 'TABLE' AND " + this.quote("installed_rank") + " > ? ORDER BY " + this.quote("installed_rank");
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        try {
            String user = ((H2Connection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT USER()", new String[0]);
            if (this.compatibilityMode == CompatibilityMode.Oracle && (user == null || "".equals(user))) {
                user = DEFAULT_USER;
            }
            return user;
        }
        catch (Exception e) {
            if (this.compatibilityMode == CompatibilityMode.Oracle) {
                return DEFAULT_USER;
            }
            throw e;
        }
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return this.requiresV2MetadataColumnNames ? "FALSE" : "0";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    private static enum CompatibilityMode {
        REGULAR,
        STRICT,
        LEGACY,
        DB2,
        Derby,
        HSQLDB,
        MSSQLServer,
        MariaDB,
        MySQL,
        Oracle,
        PostgreSQL,
        Ignite;

    }
}

