/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.database.h2;

import bending.libraries.flywaydb.core.api.ResourceProvider;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.internal.database.base.BaseDatabaseType;
import bending.libraries.flywaydb.core.internal.database.base.Database;
import bending.libraries.flywaydb.core.internal.database.h2.H2Database;
import bending.libraries.flywaydb.core.internal.database.h2.H2Parser;
import bending.libraries.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import bending.libraries.flywaydb.core.internal.jdbc.StatementInterceptor;
import bending.libraries.flywaydb.core.internal.parser.Parser;
import bending.libraries.flywaydb.core.internal.parser.ParsingContext;
import java.sql.Connection;

public class H2DatabaseType
extends BaseDatabaseType {
    @Override
    public String getName() {
        return "H2";
    }

    @Override
    public int getNullType() {
        return 12;
    }

    @Override
    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:h2:") || url.startsWith("jdbc:p6spy:h2:");
    }

    @Override
    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:h2:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        return "bending.libraries.h2.Driver";
    }

    @Override
    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith("H2");
    }

    @Override
    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new H2Database(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    @Override
    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new H2Parser(configuration, parsingContext);
    }
}

