/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.database.sqlite;

import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.internal.database.base.Database;
import bending.libraries.flywaydb.core.internal.database.base.Schema;
import bending.libraries.flywaydb.core.internal.database.base.Table;
import bending.libraries.flywaydb.core.internal.database.sqlite.SQLiteConnection;
import bending.libraries.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import bending.libraries.flywaydb.core.internal.jdbc.StatementInterceptor;
import java.sql.Connection;

public class SQLiteDatabase
extends Database<SQLiteConnection> {
    public SQLiteDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    @Override
    protected SQLiteConnection doGetConnection(Connection connection) {
        return new SQLiteConnection(this, connection);
    }

    @Override
    public void ensureSupported(Configuration configuration) {
    }

    @Override
    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE " + String.valueOf(table) + " (\n    \"installed_rank\" INT NOT NULL PRIMARY KEY,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INT,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TEXT NOT NULL DEFAULT (strftime('%Y-%m-%d %H:%M:%f','now')),\n    \"execution_time\" INT NOT NULL,\n    \"success\" BOOLEAN NOT NULL\n);\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "") + "CREATE INDEX \"" + ((Schema)table.getSchema()).getName() + "\".\"" + table.getName() + "_s_idx\" ON \"" + table.getName() + "\" (\"success\");";
    }

    @Override
    protected String doGetCurrentUser() {
        return "";
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public boolean catalogIsSchema() {
        return true;
    }

    @Override
    public boolean useSingleConnection() {
        return true;
    }
}

