/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.database.sqlite;

import bending.libraries.flywaydb.core.api.ResourceProvider;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.internal.database.base.BaseDatabaseType;
import bending.libraries.flywaydb.core.internal.database.base.Database;
import bending.libraries.flywaydb.core.internal.database.sqlite.SQLiteDatabase;
import bending.libraries.flywaydb.core.internal.database.sqlite.SQLiteParser;
import bending.libraries.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import bending.libraries.flywaydb.core.internal.jdbc.StatementInterceptor;
import bending.libraries.flywaydb.core.internal.parser.Parser;
import bending.libraries.flywaydb.core.internal.parser.ParsingContext;
import java.sql.Connection;

public class SQLiteDatabaseType
extends BaseDatabaseType {
    @Override
    public String getName() {
        return "SQLite";
    }

    @Override
    public int getNullType() {
        return 12;
    }

    @Override
    public boolean supportsReadOnlyTransactions() {
        return false;
    }

    @Override
    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:sqlite:") || url.startsWith("jdbc:sqldroid:") || url.startsWith("jdbc:p6spy:sqlite:") || url.startsWith("jdbc:p6spy:sqldroid:");
    }

    @Override
    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:sqlite:") || url.startsWith("jdbc:p6spy:sqldroid:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        if (url.startsWith("jdbc:sqldroid:")) {
            return "org.sqldroid.SQLDroidDriver";
        }
        return "org.sqlite.JDBC";
    }

    @Override
    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith("SQLite");
    }

    @Override
    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new SQLiteDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    @Override
    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new SQLiteParser(configuration, parsingContext);
    }
}

