/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.database.sqlite;

import bending.libraries.flywaydb.core.api.logging.Log;
import bending.libraries.flywaydb.core.api.logging.LogFactory;
import bending.libraries.flywaydb.core.internal.database.base.Table;
import bending.libraries.flywaydb.core.internal.database.sqlite.SQLiteDatabase;
import bending.libraries.flywaydb.core.internal.database.sqlite.SQLiteSchema;
import bending.libraries.flywaydb.core.internal.jdbc.JdbcTemplate;
import java.sql.SQLException;
import lombok.Generated;

public class SQLiteTable
extends Table<SQLiteDatabase, SQLiteSchema> {
    @Generated
    private static final Log LOG = LogFactory.getLog(SQLiteTable.class);
    static final String SQLITE_SEQUENCE = "sqlite_sequence";
    private final boolean undroppable;

    public SQLiteTable(JdbcTemplate jdbcTemplate, SQLiteDatabase database, SQLiteSchema schema, String name) {
        super(jdbcTemplate, database, schema, name);
        this.undroppable = SQLITE_SEQUENCE.equals(name);
    }

    @Override
    protected void doDrop() throws SQLException {
        if (this.undroppable) {
            LOG.debug("SQLite system table " + String.valueOf(this) + " cannot be dropped. Ignoring.");
        } else {
            String dropSql = "DROP TABLE " + ((SQLiteDatabase)this.database).quote(((SQLiteSchema)this.schema).getName(), this.name);
            if (((SQLiteSchema)this.getSchema()).getForeignKeysEnabled()) {
                dropSql = "PRAGMA foreign_keys = OFF; " + dropSql + "; PRAGMA foreign_keys = ON";
            }
            this.jdbcTemplate.execute(dropSql, new Object[0]);
        }
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT count(tbl_name) FROM " + ((SQLiteDatabase)this.database).quote(((SQLiteSchema)this.schema).getName()) + ".sqlite_master WHERE type='table' AND tbl_name='" + this.name + "'", new String[0]) > 0;
    }

    @Override
    protected void doLock() {
        LOG.debug("Unable to lock " + String.valueOf(this) + " as SQLite does not support locking. No concurrent migration supported.");
    }
}

