/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.exception;

import bending.libraries.flywaydb.core.api.CoreErrorCode;
import bending.libraries.flywaydb.core.api.FlywayException;
import bending.libraries.flywaydb.core.internal.database.DatabaseTypeRegister;
import bending.libraries.flywaydb.core.internal.exception.sqlExceptions.FlywaySqlErrorCode;
import bending.libraries.flywaydb.core.internal.exception.sqlExceptions.FlywaySqlNoDriversForInteractiveAuthException;
import bending.libraries.flywaydb.core.internal.exception.sqlExceptions.FlywaySqlNoIntegratedAuthException;
import bending.libraries.flywaydb.core.internal.exception.sqlExceptions.FlywaySqlServerUntrustedCertificateSqlException;
import bending.libraries.flywaydb.core.internal.jdbc.DriverDataSource;
import bending.libraries.flywaydb.core.internal.util.ExceptionUtils;
import bending.libraries.flywaydb.core.internal.util.StringUtils;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;

public class FlywaySqlException
extends FlywayException {
    private final FlywaySqlErrorCode subErrorCode;
    private final String sqlState;
    private final int sqlErrorCode;
    private final Throwable innerCause;

    private static List<Class<? extends FlywaySqlException>> getSpecificFlywaySqlExceptionClasses() {
        return List.of(FlywaySqlServerUntrustedCertificateSqlException.class, FlywaySqlNoIntegratedAuthException.class, FlywaySqlNoDriversForInteractiveAuthException.class);
    }

    public FlywaySqlException(String message, SQLException sqlException) {
        this(message, sqlException, null);
    }

    public FlywaySqlException(String message, SQLException sqlException, FlywaySqlErrorCode subErrorCode) {
        super(message, sqlException, CoreErrorCode.DB_CONNECTION);
        this.subErrorCode = subErrorCode;
        this.sqlState = sqlException.getSQLState();
        this.sqlErrorCode = sqlException.getErrorCode();
        this.innerCause = sqlException.getCause();
    }

    @Override
    public String getMessage() {
        String title = super.getMessage();
        String underline = StringUtils.trimOrPad("", title.length(), '-');
        return title + "\n" + underline + "\n" + ExceptionUtils.toMessage((SQLException)this.getCause());
    }

    public static void throwFlywayExceptionIfPossible(SQLException sqlException, DataSource dataSource) {
        for (Class<? extends FlywaySqlException> x : FlywaySqlException.getSpecificFlywaySqlExceptionClasses()) {
            if (!((Boolean)x.getMethod("isFlywaySpecificVersionOf", SQLException.class).invoke(null, sqlException)).booleanValue()) continue;
            throw x.getDeclaredConstructor(SQLException.class, DataSource.class).newInstance(sqlException, dataSource);
        }
    }

    protected static String getDataSourceInfo(DataSource dataSource, boolean suppressNullUserMessage) {
        if (!(dataSource instanceof DriverDataSource)) {
            return "";
        }
        DriverDataSource driverDataSource = (DriverDataSource)dataSource;
        String user = driverDataSource.getUser();
        String info = " (" + DatabaseTypeRegister.redactJdbcUrl(driverDataSource.getUrl()) + ")";
        if (user != null || !suppressNullUserMessage) {
            info = info + " for user '" + user + "'";
        }
        return info;
    }

    @Generated
    public FlywaySqlErrorCode getSubErrorCode() {
        return this.subErrorCode;
    }

    @Generated
    public String getSqlState() {
        return this.sqlState;
    }

    @Generated
    public int getSqlErrorCode() {
        return this.sqlErrorCode;
    }

    @Generated
    public Throwable getInnerCause() {
        return this.innerCause;
    }
}

