/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.info;

import bending.libraries.flywaydb.core.api.MigrationFilter;
import bending.libraries.flywaydb.core.api.MigrationInfo;
import bending.libraries.flywaydb.core.api.MigrationState;
import bending.libraries.flywaydb.core.api.MigrationVersion;
import java.util.Arrays;
import java.util.Date;

public class MigrationFilterImpl
implements MigrationFilter {
    public final Date fromDate;
    public final Date toDate;
    public final MigrationVersion fromVersion;
    public final MigrationVersion toVersion;
    public final MigrationState[] ofStates;

    public MigrationFilterImpl(Date fromDate, Date toDate, MigrationVersion fromVersion, MigrationVersion toVersion, MigrationState ... ofStates) {
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.fromVersion = fromVersion;
        this.toVersion = toVersion;
        this.ofStates = ofStates;
    }

    @Override
    public boolean matches(MigrationInfo info) {
        MigrationState state = info.getState();
        Date installedOn = info.getInstalledOn();
        MigrationVersion version = info.getVersion();
        boolean afterFromDate = this.fromDate == null || installedOn == null || installedOn.after(this.fromDate);
        boolean beforeToDate = this.toDate == null || installedOn != null && installedOn.before(this.toDate);
        boolean afterFromVersion = this.fromVersion == null || version == null || version.compareTo(this.fromVersion) >= 0;
        boolean beforeToVersion = this.toVersion == null || version != null && version.compareTo(this.toVersion) <= 0;
        boolean matchesState = this.ofStates == null || this.ofStates.length == 0 || Arrays.stream(this.ofStates).anyMatch(s -> s == state);
        return afterFromDate && beforeToDate && afterFromVersion && beforeToVersion && matchesState;
    }
}

