/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.jdbc;

import bending.libraries.flywaydb.core.api.CoreErrorCode;
import bending.libraries.flywaydb.core.api.FlywayException;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.api.logging.Log;
import bending.libraries.flywaydb.core.api.logging.LogFactory;
import bending.libraries.flywaydb.core.internal.database.DatabaseType;
import bending.libraries.flywaydb.core.internal.database.DatabaseTypeRegister;
import bending.libraries.flywaydb.core.internal.util.ClassUtils;
import bending.libraries.flywaydb.core.internal.util.StringUtils;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import lombok.Generated;

public class DriverDataSource
implements DataSource {
    @Generated
    private static final Log LOG = LogFactory.getLog(DriverDataSource.class);
    private Driver driver;
    private final String url;
    private DatabaseType type;
    private final String user;
    private final String password;
    private final Properties defaultProperties;
    private final Map<String, String> additionalProperties;
    private boolean autoCommit = true;

    public DriverDataSource(ClassLoader classLoader, String driverClass, String url, String user, String password) throws FlywayException {
        this(classLoader, driverClass, url, user, password, null, new Properties(), new HashMap<String, String>());
    }

    public DriverDataSource(ClassLoader classLoader, String driverClass, String url, String user, String password, Configuration configuration) throws FlywayException {
        this(classLoader, driverClass, url, user, password, configuration, new Properties(), new HashMap<String, String>());
    }

    public DriverDataSource(ClassLoader classLoader, String driverClass, String url, String user, String password, Map<String, String> additionalProperties) throws FlywayException {
        this(classLoader, driverClass, url, user, password, null, new Properties(), additionalProperties);
    }

    public DriverDataSource(ClassLoader classLoader, String driverClass, String url, String user, String password, Configuration configuration, Map<String, String> additionalProperties) throws FlywayException {
        this(classLoader, driverClass, url, user, password, configuration, new Properties(), additionalProperties);
    }

    public DriverDataSource(ClassLoader classLoader, String driverClass, String url, String user, String password, Configuration configuration, Properties defaultProperties, Map<String, String> additionalProperties) throws FlywayException {
        this.url = this.detectFallbackUrl(url);
        List<DatabaseType> typesAcceptingUrl = DatabaseTypeRegister.getDatabaseTypesForUrl(url, configuration);
        if (typesAcceptingUrl.isEmpty()) {
            throw new FlywayException("No Flyway database plugin found to handle " + DatabaseTypeRegister.redactJdbcUrl(url) + ". See https://rd.gt/423f9a6 for troubleshooting");
        }
        for (DatabaseType type : typesAcceptingUrl) {
            String mainDriverClass = StringUtils.hasLength(driverClass) ? driverClass : type.getDriverClass(url, classLoader);
            type.setEarlyConnectionProps();
            try {
                this.driver = (Driver)ClassUtils.instantiate(mainDriverClass, classLoader);
            }
            catch (FlywayException e) {
                Object extendedError = type.instantiateClassExtendedErrorMessage();
                if (StringUtils.hasLength(driverClass)) {
                    throw new FlywayException("Unable to instantiate JDBC driver: " + driverClass + " => Check whether the jar file is present" + (String)extendedError, e, CoreErrorCode.JDBC_DRIVER);
                }
                String backupDriverClass = type.getBackupDriverClass(url, classLoader);
                if (backupDriverClass == null) {
                    if (StringUtils.hasText((String)extendedError)) {
                        extendedError = System.lineSeparator() + (String)extendedError;
                    }
                    LOG.debug("Unable to instantiate JDBC driver: " + mainDriverClass + " => Check whether the jar file is present." + (String)extendedError);
                    continue;
                }
                try {
                    this.driver = (Driver)ClassUtils.instantiate(backupDriverClass, classLoader);
                }
                catch (Exception e1) {
                    LOG.debug("Unable to instantiate JDBC driver: " + mainDriverClass + " or backup driver: " + backupDriverClass + " => Check whether the jar file is present");
                    continue;
                }
            }
            this.type = type;
            break;
        }
        if (this.type == null) {
            throw new FlywayException("No JDBC driver found to handle " + DatabaseTypeRegister.redactJdbcUrl(url) + ". See https://rd.gt/423f9a6 for troubleshooting");
        }
        this.additionalProperties = additionalProperties != null ? additionalProperties : new HashMap<String, String>();
        this.defaultProperties = new Properties(defaultProperties);
        this.type.setDefaultConnectionProps(url, this.defaultProperties, classLoader);
        this.type.setConfigConnectionProps(configuration, this.defaultProperties, classLoader);
        this.type.setOverridingConnectionProps(this.additionalProperties);
        this.user = this.detectFallbackUser(user);
        this.password = this.detectFallbackPassword(password);
        if (this.type.externalAuthPropertiesRequired(url, user, password)) {
            this.defaultProperties.putAll((Map<?, ?>)this.type.getExternalAuthProperties(url, user));
        }
    }

    private String detectFallbackUrl(String url) {
        if (!StringUtils.hasText(url)) {
            String boxfuseDatabaseUrl = System.getenv("BOXFUSE_DATABASE_URL");
            if (StringUtils.hasText(boxfuseDatabaseUrl)) {
                return boxfuseDatabaseUrl;
            }
            throw new FlywayException("Missing required JDBC URL. Unable to create DataSource!");
        }
        return url;
    }

    private String detectFallbackUser(String user) {
        String boxfuseDatabaseUser;
        if (!StringUtils.hasText(user) && StringUtils.hasText(boxfuseDatabaseUser = System.getenv("BOXFUSE_DATABASE_USER"))) {
            return boxfuseDatabaseUser;
        }
        return user;
    }

    private String detectFallbackPassword(String password) {
        String boxfuseDatabasePassword;
        if (!StringUtils.hasText(password) && StringUtils.hasText(boxfuseDatabasePassword = System.getenv("BOXFUSE_DATABASE_PASSWORD"))) {
            return boxfuseDatabasePassword;
        }
        return password;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnectionFromDriver(this.getUser(), this.getPassword());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnectionFromDriver(username, password);
    }

    protected Connection getConnectionFromDriver(String username, String password) throws SQLException {
        Connection connection;
        Properties properties = new Properties(this.defaultProperties);
        properties.putAll(this.additionalProperties);
        if (username != null) {
            properties.setProperty("user", username);
        }
        if (password != null) {
            properties.setProperty("password", password);
        }
        if ((connection = this.driver.connect(this.url, properties)) == null) {
            throw new FlywayException("Unable to connect to " + DatabaseTypeRegister.redactJdbcUrl(this.url));
        }
        connection.setAutoCommit(this.autoCommit);
        return connection;
    }

    public void shutdownDatabase() {
        this.type.shutdownDatabase(this.url, this.driver);
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    @Override
    public void setLoginTimeout(int timeout) {
        this.unsupportedMethod("setLoginTimeout");
    }

    @Override
    public PrintWriter getLogWriter() {
        this.unsupportedMethod("getLogWriter");
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter pw) {
        this.unsupportedMethod("setLogWriter");
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        this.unsupportedMethod("unwrap");
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return DataSource.class.equals(iface);
    }

    @Override
    public Logger getParentLogger() {
        this.unsupportedMethod("getParentLogger");
        return null;
    }

    private void unsupportedMethod(String methodName) {
        throw new UnsupportedOperationException(methodName);
    }

    @Generated
    public Driver getDriver() {
        return this.driver;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Generated
    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    @Generated
    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }
}

