/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.jdbc;

import bending.libraries.flywaydb.core.api.FlywayException;
import bending.libraries.flywaydb.core.api.logging.Log;
import bending.libraries.flywaydb.core.api.logging.LogFactory;
import bending.libraries.flywaydb.core.internal.exception.FlywaySqlException;
import bending.libraries.flywaydb.core.internal.jdbc.ExecutionTemplate;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import lombok.Generated;

public class PlainExecutionTemplate
implements ExecutionTemplate {
    @Generated
    private static final Log LOG = LogFactory.getLog(PlainExecutionTemplate.class);
    private final boolean skipErrorLog;

    public PlainExecutionTemplate() {
        this.skipErrorLog = false;
    }

    public PlainExecutionTemplate(boolean skipErrorLog) {
        this.skipErrorLog = skipErrorLog;
    }

    @Override
    public <T> T execute(Callable<T> callback) {
        try {
            LOG.debug("Performing operation in non-transactional context.");
            return callback.call();
        }
        catch (Exception e) {
            if (!this.skipErrorLog) {
                LOG.error("Failed to execute operation in non-transactional context. Please restore backups and roll back database and code!");
            }
            if (e instanceof SQLException) {
                throw new FlywaySqlException("Failed to execute operation.", (SQLException)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new FlywayException(e);
        }
    }
}

