/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.jdbc;

import bending.libraries.flywaydb.core.api.FlywayException;
import bending.libraries.flywaydb.core.api.logging.Log;
import bending.libraries.flywaydb.core.api.logging.LogFactory;
import bending.libraries.flywaydb.core.internal.exception.FlywaySqlException;
import bending.libraries.flywaydb.core.internal.jdbc.ExecutionTemplate;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import lombok.Generated;

public class TransactionalExecutionTemplate
implements ExecutionTemplate {
    @Generated
    private static final Log LOG = LogFactory.getLog(TransactionalExecutionTemplate.class);
    private final Connection connection;
    private final boolean rollbackOnException;

    @Override
    public <T> T execute(Callable<T> callback) {
        boolean oldAutocommit = true;
        try {
            oldAutocommit = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            T result = callback.call();
            this.connection.commit();
            T t = result;
            return t;
        }
        catch (Exception e) {
            RuntimeException rethrow = e instanceof SQLException ? new FlywaySqlException("Unable to commit transaction", (SQLException)e) : (e instanceof RuntimeException ? (RuntimeException)e : new FlywayException(e));
            if (this.rollbackOnException) {
                try {
                    LOG.debug("Rolling back transaction...");
                    this.connection.rollback();
                    LOG.debug("Transaction rolled back");
                }
                catch (SQLException se) {
                    LOG.error("Unable to rollback transaction", se);
                }
            } else {
                try {
                    this.connection.commit();
                }
                catch (SQLException se) {
                    LOG.error("Unable to commit transaction", se);
                }
            }
            throw rethrow;
        }
        finally {
            try {
                this.connection.setAutoCommit(oldAutocommit);
            }
            catch (SQLException e) {
                LOG.error("Unable to restore autocommit to original value for connection", e);
            }
        }
    }

    @Generated
    public TransactionalExecutionTemplate(Connection connection, boolean rollbackOnException) {
        this.connection = connection;
        this.rollbackOnException = rollbackOnException;
    }
}

