/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.license;

import bending.libraries.flywaydb.core.api.FlywayException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionUtils {
    public static SecretKey getKeyFromPassword(String password, String salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt.getBytes(), 65536, 256);
        SecretKeySpec secret = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
        return secret;
    }

    public static SealedObject encryptObject(String algorithm, Serializable object, SecretKey key, IvParameterSpec iv) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IOException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(1, (Key)key, iv);
        return new SealedObject(object, cipher);
    }

    public static Serializable decryptObject(String algorithm, SealedObject sealedObject, SecretKey key, IvParameterSpec iv) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, ClassNotFoundException, BadPaddingException, IllegalBlockSizeException, IOException {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(2, (Key)key, iv);
        return (Serializable)sealedObject.getObject(cipher);
    }

    public static byte[] toByteArray(SealedObject sealedObject) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream out = new ObjectOutputStream(bos);){
                out.writeObject(sealedObject);
                out.flush();
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    public static SealedObject fromByteArray(byte[] byteArray) throws IOException, ClassNotFoundException {
        return (SealedObject)new ObjectInputStream(new ByteArrayInputStream(byteArray)).readObject();
    }

    public static String hashString(String strInput, String hashInput) {
        if (strInput == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(strInput.getBytes(StandardCharsets.UTF_8));
            byte[] hash = md.digest(hashInput.getBytes(StandardCharsets.UTF_8));
            BigInteger number = new BigInteger(1, hash);
            Object result = number.toString(16);
            while (((String)result).length() < 64) {
                result = "0" + (String)result;
            }
            return result;
        }
        catch (Exception e) {
            throw new FlywayException(e);
        }
    }
}

