/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.nc.schemahistory;

import bending.libraries.flywaydb.core.api.CoreMigrationType;
import bending.libraries.flywaydb.core.api.MigrationVersion;
import bending.libraries.flywaydb.core.extensibility.MigrationType;
import bending.libraries.flywaydb.core.internal.nc.schemahistory.SchemaHistoryItem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class SchemaHistoryModel {
    private final List<SchemaHistoryItem> schemaHistoryItems;

    public SchemaHistoryModel() {
        this(List.of());
    }

    public List<SchemaHistoryItem> getSchemaHistoryItems() {
        return Collections.unmodifiableList(this.schemaHistoryItems);
    }

    public Optional<SchemaHistoryItem> getSchemaHistoryItem(int installedRank) {
        return this.getSchemaHistoryItems().stream().filter(x -> x.getInstalledRank() == installedRank).findFirst();
    }

    public int calculateInstalledRank(MigrationType type) {
        if (this.schemaHistoryItems.isEmpty()) {
            return type == CoreMigrationType.SCHEMA ? 0 : 1;
        }
        return this.schemaHistoryItems.stream().map(SchemaHistoryItem::getInstalledRank).max(Integer::compareTo).orElse(0) + 1;
    }

    public MigrationVersion getInitialVersion() {
        return this.schemaHistoryItems.stream().map(SchemaHistoryItem::getVersion).filter(Objects::nonNull).map(MigrationVersion::fromVersion).max(MigrationVersion::compareTo).orElse(MigrationVersion.EMPTY);
    }

    @Generated
    public SchemaHistoryModel(List<SchemaHistoryItem> schemaHistoryItems) {
        this.schemaHistoryItems = schemaHistoryItems;
    }
}

