/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.parser;

import bending.libraries.flywaydb.core.internal.parser.PositionTracker;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class PositionTrackingReader
extends FilterReader {
    private final PositionTracker tracker;
    private boolean paused;

    PositionTrackingReader(PositionTracker tracker, Reader in) {
        super(in);
        this.tracker = tracker;
    }

    @Override
    public int read() throws IOException {
        int read = super.read();
        if (read != -1 && !this.paused) {
            this.tracker.nextPos();
            char c = (char)read;
            if (c == '\n') {
                this.tracker.linefeed();
            } else if (c == '\r') {
                this.tracker.carriageReturn();
            } else {
                if (!Character.isWhitespace(c)) {
                    this.tracker.nextColIgnoringWhitespace();
                }
                this.tracker.nextCol();
            }
        }
        return read;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.paused = true;
        super.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.paused = false;
    }
}

