/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.proprietaryStubs;

import bending.libraries.flywaydb.core.TelemetrySpan;
import bending.libraries.flywaydb.core.api.FlywayException;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.api.output.OperationResult;
import bending.libraries.flywaydb.core.extensibility.CommandExtension;
import bending.libraries.flywaydb.core.extensibility.EventTelemetryModel;
import bending.libraries.flywaydb.core.internal.license.FlywayRedgateEditionRequiredException;
import bending.libraries.flywaydb.core.internal.util.TelemetryUtils;
import java.util.List;
import java.util.Locale;

public class DiffCommandExtensionStub
implements CommandExtension {
    private static final String FEATURE_NAME = "Diff";
    public static final String COMMAND = "Diff".toLowerCase(Locale.ROOT);
    public static final String DESCRIPTION = "Calculates the differences between a specified source and target. The result of a diff command can then be used with the generate, model and diffText commands to generate scripts and apply changes";

    @Override
    public boolean handlesCommand(String command) {
        return COMMAND.equals(command);
    }

    @Override
    public boolean handlesParameter(String parameter) {
        return false;
    }

    @Override
    public OperationResult handle(String command, Configuration config, List<String> flags) throws FlywayException {
        return TelemetrySpan.trackSpan(new EventTelemetryModel(command, TelemetryUtils.getTelemetryManager(config)), telemetryModel -> {
            throw new FlywayRedgateEditionRequiredException(FEATURE_NAME);
        });
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public int getPriority() {
        return -100;
    }
}

