/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.resolver.java;

import bending.libraries.flywaydb.core.api.FlywayException;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.api.executor.MigrationExecutor;
import bending.libraries.flywaydb.core.api.migration.Context;
import bending.libraries.flywaydb.core.api.migration.JavaMigration;
import bending.libraries.flywaydb.core.internal.database.DatabaseExecutionStrategy;
import bending.libraries.flywaydb.core.internal.database.DatabaseType;
import bending.libraries.flywaydb.core.internal.database.DatabaseTypeRegister;
import bending.libraries.flywaydb.core.internal.jdbc.Results;
import bending.libraries.flywaydb.core.internal.jdbc.StatementInterceptor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import lombok.Generated;

public class JavaMigrationExecutor
implements MigrationExecutor {
    private final JavaMigration javaMigration;
    private final StatementInterceptor statementInterceptor;

    @Override
    public List<Results> execute(bending.libraries.flywaydb.core.api.executor.Context context) throws SQLException {
        if (this.statementInterceptor != null) {
            this.statementInterceptor.javaMigration(this.javaMigration);
        } else {
            DatabaseType databaseType = DatabaseTypeRegister.getDatabaseTypeForConnection(context.getConnection(), context.getConfiguration());
            DatabaseExecutionStrategy strategy = databaseType.createExecutionStrategy(context.getConnection());
            strategy.execute(() -> {
                this.executeOnce(context);
                return true;
            });
        }
        return List.of();
    }

    private void executeOnce(final bending.libraries.flywaydb.core.api.executor.Context context) throws SQLException {
        try {
            this.javaMigration.migrate(new Context(){

                @Override
                public Configuration getConfiguration() {
                    return context.getConfiguration();
                }

                @Override
                public Connection getConnection() {
                    return context.getConnection();
                }
            });
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FlywayException("Migration failed !", e);
        }
    }

    @Override
    public boolean canExecuteInTransaction() {
        return this.javaMigration.canExecuteInTransaction();
    }

    @Override
    public boolean shouldExecute() {
        return true;
    }

    @Generated
    public JavaMigrationExecutor(JavaMigration javaMigration, StatementInterceptor statementInterceptor) {
        this.javaMigration = javaMigration;
        this.statementInterceptor = statementInterceptor;
    }
}

