/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.resolver.java;

import bending.libraries.flywaydb.core.api.ClassProvider;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.api.migration.JavaMigration;
import bending.libraries.flywaydb.core.api.resolver.MigrationResolver;
import bending.libraries.flywaydb.core.api.resolver.ResolvedMigration;
import bending.libraries.flywaydb.core.internal.resolver.ResolvedMigrationComparator;
import bending.libraries.flywaydb.core.internal.util.ClassUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class ScanningJavaMigrationResolver
implements MigrationResolver {
    private final ClassProvider<JavaMigration> classProvider;
    private final Configuration configuration;

    public List<ResolvedMigration> resolveMigrations(MigrationResolver.Context context) {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        for (Class<JavaMigration> clazz : this.classProvider.getClasses()) {
            JavaMigration javaMigration = (JavaMigration)ClassUtils.instantiate(clazz.getName(), this.configuration.getClassLoader());
            migrations.add(javaMigration.getResolvedMigration(this.configuration, context.statementInterceptor));
        }
        migrations.sort(new ResolvedMigrationComparator());
        return migrations;
    }

    @Generated
    public ScanningJavaMigrationResolver(ClassProvider<JavaMigration> classProvider, Configuration configuration) {
        this.classProvider = classProvider;
        this.configuration = configuration;
    }
}

