/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.resolver.script;

import bending.libraries.flywaydb.core.api.CoreMigrationType;
import bending.libraries.flywaydb.core.api.ResourceProvider;
import bending.libraries.flywaydb.core.api.callback.CallbackEvent;
import bending.libraries.flywaydb.core.api.callback.Event;
import bending.libraries.flywaydb.core.api.callback.GenericCallback;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.api.logging.Log;
import bending.libraries.flywaydb.core.api.logging.LogFactory;
import bending.libraries.flywaydb.core.api.resolver.MigrationResolver;
import bending.libraries.flywaydb.core.api.resolver.ResolvedMigration;
import bending.libraries.flywaydb.core.api.resource.LoadableResource;
import bending.libraries.flywaydb.core.extensibility.MigrationType;
import bending.libraries.flywaydb.core.internal.callback.ArbitraryScriptCallback;
import bending.libraries.flywaydb.core.internal.jdbc.StatementInterceptor;
import bending.libraries.flywaydb.core.internal.parser.ParsingContext;
import bending.libraries.flywaydb.core.internal.parser.PlaceholderReplacingReader;
import bending.libraries.flywaydb.core.internal.resolver.ChecksumCalculator;
import bending.libraries.flywaydb.core.internal.resolver.ResolvedMigrationComparator;
import bending.libraries.flywaydb.core.internal.resolver.ResolvedMigrationImpl;
import bending.libraries.flywaydb.core.internal.resolver.script.ScriptMigrationExecutor;
import bending.libraries.flywaydb.core.internal.resource.ResourceName;
import bending.libraries.flywaydb.core.internal.resource.ResourceNameParser;
import bending.libraries.flywaydb.core.internal.util.StringUtils;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public class ScriptMigrationResolver<E extends CallbackEvent<E>>
implements MigrationResolver {
    @Generated
    private static final Log LOG = LogFactory.getLog(ScriptMigrationResolver.class);
    private final String[] fileTypes = new String[]{"cmd", "bat", "ps1", "py", "sh", "bash"};
    private final String[] suffixes = (String[])Arrays.stream(this.fileTypes).map(s -> "." + s).toArray(String[]::new);
    private final ResourceProvider resourceProvider;
    private final Configuration configuration;
    private final ParsingContext parsingContext;
    private final StatementInterceptor statementInterceptor;
    public final Set<GenericCallback<E>> scriptCallbacks;

    public ScriptMigrationResolver(ResourceProvider resourceProvider, Configuration configuration, ParsingContext parsingContext, StatementInterceptor statementInterceptor) {
        this.resourceProvider = resourceProvider;
        this.configuration = configuration;
        this.parsingContext = parsingContext;
        this.statementInterceptor = statementInterceptor;
        this.scriptCallbacks = new HashSet<GenericCallback<E>>();
    }

    @Override
    public Collection<ResolvedMigration> resolveMigrations(MigrationResolver.Context context) {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        this.addMigrations(CoreMigrationType.SCRIPT, migrations, this.configuration.getSqlMigrationPrefix(), false);
        for (MigrationResolver migrationResolver : context.configuration.getPluginRegister().getInstancesOf(MigrationResolver.class)) {
            String prefix = migrationResolver.getPrefix(context.configuration);
            if (prefix == null) continue;
            MigrationType migrationType = migrationResolver.getDefaultMigrationType();
            if (migrationType == null) {
                this.addMigrations(CoreMigrationType.SCRIPT, migrations, prefix, false);
                continue;
            }
            this.addMigrations(migrationType.isUndo() ? CoreMigrationType.UNDO_SCRIPT : migrationType, migrations, prefix, false);
        }
        this.addMigrations(CoreMigrationType.SCRIPT, migrations, this.configuration.getRepeatableSqlMigrationPrefix(), true);
        migrations.sort(new ResolvedMigrationComparator());
        return migrations;
    }

    private LoadableResource[] createPlaceholderReplacingLoadableResources(List<LoadableResource> loadableResources) {
        ArrayList<1> list = new ArrayList<1>();
        for (final LoadableResource loadableResource : loadableResources) {
            LoadableResource placeholderReplacingLoadableResource = new LoadableResource(){

                @Override
                public Reader read() {
                    return PlaceholderReplacingReader.createForScriptMigration(ScriptMigrationResolver.this.configuration, ScriptMigrationResolver.this.parsingContext, loadableResource.read());
                }

                @Override
                public String getAbsolutePath() {
                    return loadableResource.getAbsolutePath();
                }

                @Override
                public String getAbsolutePathOnDisk() {
                    return loadableResource.getAbsolutePathOnDisk();
                }

                @Override
                public String getFilename() {
                    return loadableResource.getFilename();
                }

                @Override
                public String getRelativePath() {
                    return loadableResource.getRelativePath();
                }
            };
            list.add(placeholderReplacingLoadableResource);
        }
        return (LoadableResource[])list.toArray(LoadableResource[]::new);
    }

    private Integer getChecksumForLoadableResource(boolean repeatable, List<LoadableResource> loadableResources) {
        if (repeatable && this.configuration.isPlaceholderReplacement()) {
            return ChecksumCalculator.calculate(this.createPlaceholderReplacingLoadableResources(loadableResources));
        }
        return ChecksumCalculator.calculate((LoadableResource[])loadableResources.toArray(LoadableResource[]::new));
    }

    private Integer getEquivalentChecksumForLoadableResource(boolean repeatable, List<LoadableResource> loadableResources) {
        if (repeatable) {
            return ChecksumCalculator.calculate((LoadableResource[])loadableResources.toArray(LoadableResource[]::new));
        }
        return null;
    }

    private void addMigrations(MigrationType migrationType, List<ResolvedMigration> migrations, String prefix, boolean repeatable) {
        ResourceNameParser resourceNameParser = new ResourceNameParser(this.configuration);
        for (LoadableResource resource : this.resourceProvider.getResources(prefix, new String[]{""})) {
            String filename = resource.getFilename();
            ResourceName result = resourceNameParser.parse(filename, this.suffixes);
            if (!result.isValid() || ScriptMigrationResolver.isCallback(result) || !prefix.equals(result.getPrefix()) || this.isNotScriptFile(filename)) continue;
            ArrayList<LoadableResource> resources = new ArrayList<LoadableResource>();
            resources.add(resource);
            Integer checksum = this.getChecksumForLoadableResource(repeatable, resources);
            Integer equivalentChecksum = this.getEquivalentChecksumForLoadableResource(repeatable, resources);
            migrations.add(new ResolvedMigrationImpl(result.getVersion(), result.getDescription(), resource.getRelativePath(), checksum, equivalentChecksum, migrationType, resource.getAbsolutePathOnDisk(), new ScriptMigrationExecutor(resource, this.parsingContext, result, this.statementInterceptor)));
        }
    }

    public void resolveCallbacks(ParseCallbackEvent<E> parseCallbackEvent) {
        ResourceNameParser resourceNameParser = new ResourceNameParser(this.configuration);
        for (LoadableResource resource : this.resourceProvider.getResources("", new String[]{""})) {
            Optional<E> maybeEvent;
            String filename = resource.getFilename();
            ResourceName result = resourceNameParser.parse(filename, this.suffixes);
            if (!result.isValid() || this.isNotScriptFile(filename) || !(maybeEvent = parseCallbackEvent.parse(result.getPrefix())).isPresent()) continue;
            LOG.debug("Found script callback: " + resource.getAbsolutePath() + " (filename: " + resource.getFilename() + ")");
            this.scriptCallbacks.add(new ArbitraryScriptCallback<CallbackEvent>((CallbackEvent)maybeEvent.get(), result.getDescription(), new ScriptMigrationExecutor(resource, this.parsingContext, result, this.statementInterceptor)));
        }
    }

    boolean isNotScriptFile(String filename) {
        boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
        String extension = StringUtils.getFileNameAndExtension(filename).getRight();
        boolean isScriptFile = false;
        if (!isWindows) {
            isScriptFile = extension.isEmpty();
        }
        if (!isScriptFile) {
            for (String suffix : this.fileTypes) {
                if (!suffix.equalsIgnoreCase(extension)) continue;
                isScriptFile = true;
                break;
            }
        }
        return !isScriptFile;
    }

    private static boolean isCallback(ResourceName result) {
        return Event.fromId(result.getPrefix()) != null;
    }

    @FunctionalInterface
    public static interface ParseCallbackEvent<E extends CallbackEvent<E>> {
        public Optional<E> parse(String var1);
    }
}

