/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.resource;

import bending.libraries.flywaydb.core.api.MigrationVersion;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.extensibility.ResourceType;
import bending.libraries.flywaydb.core.extensibility.ResourceTypeProvider;
import bending.libraries.flywaydb.core.internal.resource.ResourceName;
import bending.libraries.flywaydb.core.internal.util.Pair;
import bending.libraries.flywaydb.core.internal.util.StringUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ResourceNameParser {
    private final Configuration configuration;
    private final List<Pair<String, ResourceType>> prefixes;

    public ResourceNameParser(Configuration configuration) {
        this.configuration = configuration;
        this.prefixes = this.populatePrefixes(configuration);
    }

    public ResourceName parse(String resourceName) {
        return this.parse(resourceName, this.configuration.getSqlMigrationSuffixes());
    }

    public ResourceName parse(String resourceName, String[] suffixes) {
        Pair<String, String> suffixResult = this.stripSuffix(resourceName, suffixes);
        Pair<String, ResourceType> prefix = this.findPrefix(suffixResult.getLeft(), this.prefixes);
        if (prefix != null) {
            String exampleDescription;
            Pair<String, String> prefixResult = this.stripPrefix(suffixResult.getLeft(), prefix.getLeft());
            String name = prefixResult.getRight();
            Pair<String, String> splitName = StringUtils.splitAtFirstSeparator(name, this.configuration.getSqlMigrationSeparator());
            boolean isValid = true;
            Object validationMessage = "";
            String string = exampleDescription = "".equals(splitName.getRight()) ? "description" : splitName.getRight();
            if (!prefix.getRight().isVersioned()) {
                if (!"".equals(splitName.getLeft())) {
                    isValid = false;
                    validationMessage = "Invalid repeatable migration / callback name format: " + resourceName + " (It cannot contain a version and should look like this: " + prefixResult.getLeft() + this.configuration.getSqlMigrationSeparator() + exampleDescription + suffixResult.getRight() + ")";
                }
            } else if ("".equals(splitName.getLeft())) {
                isValid = false;
                validationMessage = "Invalid versioned migration name format: " + resourceName + " (It must contain a version and should look like this: " + prefixResult.getLeft() + "1.2" + this.configuration.getSqlMigrationSeparator() + exampleDescription + suffixResult.getRight() + ")";
            } else {
                try {
                    MigrationVersion.fromVersion(splitName.getLeft());
                }
                catch (Exception e) {
                    isValid = false;
                    validationMessage = "Invalid versioned migration name format: " + resourceName + " (could not recognise version number " + splitName.getLeft() + ")";
                }
            }
            String description = splitName.getRight().replace("_", " ");
            return new ResourceName(prefixResult.getLeft(), splitName.getLeft(), this.configuration.getSqlMigrationSeparator(), description, splitName.getRight(), suffixResult.getRight(), isValid, (String)validationMessage);
        }
        return ResourceName.invalid("Unrecognised migration name format: " + resourceName);
    }

    private Pair<String, ResourceType> findPrefix(String nameWithoutSuffix, List<Pair<String, ResourceType>> prefixes) {
        for (Pair<String, ResourceType> prefix : prefixes) {
            if (!nameWithoutSuffix.startsWith(prefix.getLeft())) continue;
            return prefix;
        }
        return null;
    }

    private Pair<String, String> stripSuffix(String name, String[] suffixes) {
        for (String suffix : suffixes) {
            if (!name.toUpperCase().endsWith(suffix.toUpperCase())) continue;
            return Pair.of(name.substring(0, name.length() - suffix.length()), name.substring(name.length() - suffix.length()));
        }
        return Pair.of(name, "");
    }

    private Pair<String, String> stripPrefix(String fileName, String prefix) {
        if (fileName.startsWith(prefix)) {
            return Pair.of(prefix, fileName.substring(prefix.length()));
        }
        return null;
    }

    private List<Pair<String, ResourceType>> populatePrefixes(Configuration configuration) {
        ArrayList<Pair<String, ResourceType>> prefixes = new ArrayList<Pair<String, ResourceType>>();
        configuration.getPluginRegister().getInstancesOf(ResourceTypeProvider.class).forEach(resourceTypeProvider -> prefixes.addAll(resourceTypeProvider.getPrefixTypePairs(configuration)));
        Comparator prefixComparator = (p1, p2) -> ((String)p2.getLeft()).length() - ((String)p1.getLeft()).length();
        prefixes.sort(prefixComparator);
        return prefixes;
    }
}

