/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.resource;

import bending.libraries.flywaydb.core.api.FlywayException;
import bending.libraries.flywaydb.core.api.ResourceProvider;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.api.logging.Log;
import bending.libraries.flywaydb.core.api.logging.LogFactory;
import bending.libraries.flywaydb.core.api.resource.LoadableResource;
import bending.libraries.flywaydb.core.api.resource.Resource;
import bending.libraries.flywaydb.core.internal.database.DatabaseType;
import bending.libraries.flywaydb.core.internal.resource.ResourceName;
import bending.libraries.flywaydb.core.internal.resource.ResourceNameParser;
import bending.libraries.flywaydb.core.internal.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;

public class ResourceNameValidator {
    @Generated
    private static final Log LOG = LogFactory.getLog(ResourceNameValidator.class);

    public void validateSQLMigrationNaming(ResourceProvider provider, Configuration configuration, DatabaseType databaseType) {
        ArrayList<String> errorsFound = new ArrayList<String>();
        ResourceNameParser resourceNameParser = new ResourceNameParser(configuration);
        for (Resource resource : this.getAllSqlResources(provider, configuration)) {
            ResourceName result;
            String filename = resource.getFilename();
            LOG.debug("Validating " + filename);
            if (this.isSpecialResourceFile(configuration, filename, databaseType) || (result = resourceNameParser.parse(filename)).isValid()) continue;
            errorsFound.add(result.getValidityMessage());
        }
        if (!errorsFound.isEmpty()) {
            if (configuration.isValidateMigrationNaming()) {
                throw new FlywayException("Invalid SQL filenames found:\r\n" + StringUtils.collectionToDelimitedString(errorsFound, "\r\n"));
            }
            LOG.info(errorsFound.size() + " SQL migrations were detected but not run because they did not follow the filename convention.");
            LOG.info("Set 'validateMigrationNaming' to true to fail fast and see a list of the invalid file names.");
        }
    }

    private Collection<LoadableResource> getAllSqlResources(ResourceProvider provider, Configuration configuration) {
        return provider.getResources("", configuration.getSqlMigrationSuffixes());
    }

    private boolean isSpecialResourceFile(Configuration configuration, String filename, DatabaseType databaseType) {
        return databaseType != null && databaseType.getSpecialResourceFilenames(configuration).contains(filename.toLowerCase());
    }
}

