/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.scanner;

import bending.libraries.flywaydb.core.api.resource.LoadableResource;
import bending.libraries.flywaydb.core.internal.scanner.LocationParser;
import bending.libraries.flywaydb.core.internal.scanner.LocationScannerCache;
import bending.libraries.flywaydb.core.internal.scanner.ResourceNameCache;
import bending.libraries.flywaydb.core.internal.scanner.classpath.ClassPathScanner;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class ClasspathClassScanner {
    private final ResourceNameCache resourceNameCache = new ResourceNameCache();
    private final LocationScannerCache locationScannerCache = new LocationScannerCache();
    private final ClassLoader classLoader;

    public ClasspathClassScanner(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public List<String> scanForType(String location, Class<?> classType, boolean errorOnNotFound) {
        ClassPathScanner s = new ClassPathScanner(classType, this.classLoader, Charset.defaultCharset(), LocationParser.parseLocation("classpath:" + location), this.resourceNameCache, this.locationScannerCache, errorOnNotFound, false);
        ArrayList<String> discoveredTypes = new ArrayList<String>();
        for (LoadableResource resource : s.scanForResources()) {
            if (!resource.getAbsolutePath().endsWith(".class")) continue;
            discoveredTypes.add(this.toClassName(resource.getAbsolutePath()));
        }
        return discoveredTypes;
    }

    private String toClassName(String resourceName) {
        String nameWithDots = resourceName.replace("/", ".");
        return nameWithDots.substring(0, nameWithDots.length() - ".class".length());
    }
}

