/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.scanner.classpath.jboss;

import bending.libraries.flywaydb.core.api.logging.Log;
import bending.libraries.flywaydb.core.api.logging.LogFactory;
import bending.libraries.flywaydb.core.internal.scanner.classpath.ClassPathLocationScanner;
import bending.libraries.flywaydb.core.internal.util.UrlUtils;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

public class JBossVFSv3ClassPathLocationScanner
implements ClassPathLocationScanner {
    @Generated
    private static final Log LOG = LogFactory.getLog(JBossVFSv3ClassPathLocationScanner.class);

    @Override
    public Set<String> findResourceNames(String location, URL locationUrl) {
        String filePath = UrlUtils.toFilePath(locationUrl);
        Object classPathRootOnDisk = filePath.substring(0, filePath.length() - location.length());
        if (!((String)classPathRootOnDisk).endsWith("/")) {
            classPathRootOnDisk = (String)classPathRootOnDisk + "/";
        }
        LOG.debug("Scanning starting at classpath root on JBoss VFS: " + (String)classPathRootOnDisk);
        TreeSet<String> resourceNames = new TreeSet<String>();
        try {
            List files = VFS.getChild((String)filePath).getChildrenRecursively(new VirtualFileFilter(){

                public boolean accepts(VirtualFile file) {
                    return file.isFile();
                }
            });
            for (VirtualFile file : files) {
                resourceNames.add(file.getPathName().substring(((String)classPathRootOnDisk).length()));
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to scan classpath root (" + (String)classPathRootOnDisk + ") using JBoss VFS: " + e.getMessage());
        }
        return resourceNames;
    }
}

