/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.scanner.filesystem;

import bending.libraries.flywaydb.core.api.CoreErrorCode;
import bending.libraries.flywaydb.core.api.FlywayException;
import bending.libraries.flywaydb.core.api.Location;
import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.api.resource.LoadableResource;
import bending.libraries.flywaydb.core.internal.configuration.ConfigUtils;
import bending.libraries.flywaydb.core.internal.scanner.FileLocation;
import bending.libraries.flywaydb.core.internal.scanner.ReadWriteLocationHandler;
import bending.libraries.flywaydb.core.internal.scanner.filesystem.FileSystemScanner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;

public class FilesystemLocationHandler
implements ReadWriteLocationHandler {
    public static final String FILESYSTEM_PREFIX = "filesystem:";

    @Override
    public boolean canHandlePrefix(String prefix) {
        return FILESYSTEM_PREFIX.equals(prefix);
    }

    @Override
    public Collection<LoadableResource> scanForResources(Location location, Configuration configuration) {
        boolean stream = configuration.isStream();
        FileSystemScanner fileSystemScanner = new FileSystemScanner(stream, configuration);
        return fileSystemScanner.scanForResources(location);
    }

    @Override
    public boolean handlesWildcards() {
        return true;
    }

    @Override
    public String getPathSeparator() {
        return File.separator;
    }

    @Override
    public String normalizePath(String path) {
        return new File(path).getPath();
    }

    @Override
    public OutputStream getOutputStream(FileLocation fileLocation, Configuration configuration) {
        File file;
        try {
            file = new File(ConfigUtils.getFilenameWithWorkingDirectory(fileLocation.path(), configuration)).getCanonicalFile();
        }
        catch (IOException e) {
            throw new FlywayException("Unable to get canonical path for file " + fileLocation.path() + ": " + e.getMessage(), e, CoreErrorCode.ERROR);
        }
        String path = file.getAbsolutePath();
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new FlywayException("Unable to write output to " + path + " as it is a directory and not a file", CoreErrorCode.ERROR);
            }
            if (!file.canWrite()) {
                throw new FlywayException("Unable to write output to " + path + " as it is write-protected", CoreErrorCode.ERROR);
            }
        } else {
            File dir = file.getParentFile();
            if (dir != null && !dir.exists() && !dir.mkdirs()) {
                throw new FlywayException("Unable to create parent directories for output to " + path, CoreErrorCode.ERROR);
            }
        }
        try {
            return new FileOutputStream(path);
        }
        catch (FileNotFoundException e) {
            throw new FlywayException("Unable to write to " + path + e.getMessage(), e, CoreErrorCode.CONFIGURATION);
        }
    }
}

