/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.schemahistory;

import bending.libraries.flywaydb.core.api.CoreMigrationType;
import bending.libraries.flywaydb.core.api.FlywayException;
import bending.libraries.flywaydb.core.api.MigrationPattern;
import bending.libraries.flywaydb.core.api.MigrationVersion;
import bending.libraries.flywaydb.core.api.output.RepairResult;
import bending.libraries.flywaydb.core.api.resolver.ResolvedMigration;
import bending.libraries.flywaydb.core.extensibility.AppliedMigration;
import bending.libraries.flywaydb.core.extensibility.MigrationType;
import bending.libraries.flywaydb.core.internal.database.base.Database;
import bending.libraries.flywaydb.core.internal.database.base.Schema;
import bending.libraries.flywaydb.core.internal.database.base.Table;
import bending.libraries.flywaydb.core.internal.util.AbbreviationUtils;
import bending.libraries.flywaydb.core.internal.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public abstract class SchemaHistory {
    public static final String NO_DESCRIPTION_MARKER = "<< no description >>";
    protected Table table;

    public abstract <T> T lock(Callable<T> var1);

    public abstract boolean exists();

    public abstract void create(boolean var1);

    public void drop() {
        throw new FlywayException("Dropping the schema history table is not supported for this SchemaHistory implementation");
    }

    public final boolean hasNonSyntheticAppliedMigrations() {
        for (AppliedMigration appliedMigration : this.allAppliedMigrations()) {
            if (appliedMigration.getType().isSynthetic() || appliedMigration.getType().isUndo()) continue;
            return true;
        }
        return false;
    }

    public abstract List<AppliedMigration> allAppliedMigrations();

    public final AppliedMigration getBaselineMarker() {
        List<AppliedMigration> appliedMigrations = this.allAppliedMigrations();
        for (int i = 0; i < Math.min(appliedMigrations.size(), 2); ++i) {
            AppliedMigration appliedMigration = appliedMigrations.get(i);
            if (appliedMigration.getType() != CoreMigrationType.BASELINE) continue;
            return appliedMigration;
        }
        return null;
    }

    public abstract boolean removeFailedMigrations(RepairResult var1, MigrationPattern[] var2);

    public final void addSchemasMarker(Schema[] schemas) {
        this.addAppliedMigration(null, "<< Flyway Schema Creation >>", CoreMigrationType.SCHEMA, StringUtils.arrayToCommaDelimitedString(schemas), null, 0, true);
    }

    public final boolean hasSchemasMarker() {
        List<AppliedMigration> appliedMigrations = this.allAppliedMigrations();
        return !appliedMigrations.isEmpty() && appliedMigrations.stream().anyMatch(x -> x.getType() == CoreMigrationType.SCHEMA);
    }

    public List<String> getSchemasCreatedByFlyway() {
        if (!this.hasSchemasMarker()) {
            return new ArrayList<String>();
        }
        return this.allAppliedMigrations().stream().filter(x -> x.getType() == CoreMigrationType.SCHEMA).map(AppliedMigration::getScript).flatMap(script -> Arrays.stream(script.split(","))).map(result -> ((Database)this.table.getDatabase()).unQuote((String)result)).collect(Collectors.toList());
    }

    public abstract void update(AppliedMigration var1, ResolvedMigration var2);

    public abstract void delete(AppliedMigration var1);

    public void clearCache() {
    }

    public final void addAppliedMigration(MigrationVersion version, String description, MigrationType type, String script, Integer checksum, int executionTime, boolean success) {
        int installedRank = this.calculateInstalledRank(type);
        this.doAddAppliedMigration(installedRank, version, AbbreviationUtils.abbreviateDescription(description), type, AbbreviationUtils.abbreviateScript(script), checksum, executionTime, success);
    }

    protected int calculateInstalledRank(MigrationType type) {
        List<AppliedMigration> appliedMigrations = this.allAppliedMigrations();
        if (appliedMigrations.isEmpty()) {
            return type == CoreMigrationType.SCHEMA ? 0 : 1;
        }
        return appliedMigrations.get(appliedMigrations.size() - 1).getInstalledRank() + 1;
    }

    protected abstract void doAddAppliedMigration(int var1, MigrationVersion var2, String var3, MigrationType var4, String var5, Integer var6, int var7, boolean var8);

    public String toString() {
        return this.table.toString();
    }
}

