/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.sqlscript;

import bending.libraries.flywaydb.core.api.logging.Log;
import bending.libraries.flywaydb.core.api.logging.LogFactory;
import bending.libraries.flywaydb.core.api.resource.Resource;
import bending.libraries.flywaydb.core.internal.exception.FlywaySqlException;
import bending.libraries.flywaydb.core.internal.sqlscript.SqlStatement;
import java.sql.SQLException;
import lombok.Generated;

public class FlywaySqlScriptException
extends FlywaySqlException {
    @Generated
    private static final Log LOG = LogFactory.getLog(FlywaySqlScriptException.class);
    private final Resource resource;
    private final SqlStatement statement;
    private final String decoratedMessage;
    public static final String STATEMENT_MESSAGE = "Run Flyway with -X option to see the actual statement causing the problem";

    public FlywaySqlScriptException(Resource resource, SqlStatement statement, SQLException sqlException, String environment) {
        super(FlywaySqlScriptException.generateMessage(resource, environment), sqlException);
        this.resource = resource;
        this.statement = statement;
        StringBuilder builder = new StringBuilder(super.getMessage());
        if (resource != null) {
            builder.append("Location   : ").append(resource.getAbsolutePath()).append(" (").append(resource.getAbsolutePathOnDisk()).append(")\n");
        }
        if (statement != null) {
            builder.append("Line       : ").append(this.getLineNumber()).append("\n");
            builder.append("Statement  : ").append(LOG.isDebugEnabled() ? this.getStatement() : STATEMENT_MESSAGE).append("\n");
        }
        this.decoratedMessage = builder.toString();
    }

    public int getLineNumber() {
        return this.statement == null ? -1 : this.statement.getLineNumber();
    }

    public String getStatement() {
        return this.statement == null ? "" : this.statement.getSql();
    }

    @Override
    public String getMessage() {
        return this.decoratedMessage;
    }

    private static String generateMessage(Resource resource, String environment) {
        StringBuilder messageBuilder = new StringBuilder("Failed to execute script");
        if (resource != null) {
            messageBuilder.append(" ").append(resource.getFilename());
        }
        if (!"default".equalsIgnoreCase(environment)) {
            messageBuilder.append(" against ").append(environment).append(" environment");
        }
        return messageBuilder.toString();
    }

    @Generated
    public Resource getResource() {
        return this.resource;
    }
}

