/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.sqlscript;

import bending.libraries.flywaydb.core.api.configuration.Configuration;
import bending.libraries.flywaydb.core.internal.jdbc.JdbcTemplate;
import bending.libraries.flywaydb.core.internal.jdbc.Results;
import bending.libraries.flywaydb.core.internal.sqlscript.Delimiter;
import bending.libraries.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import bending.libraries.flywaydb.core.internal.sqlscript.SqlStatement;
import lombok.Generated;

public class ParsedSqlStatement
implements SqlStatement {
    private final int pos;
    private final int line;
    private final int col;
    private final String sql;
    private final Delimiter delimiter;
    private final boolean canExecuteInTransaction;
    private final boolean batchable;

    public ParsedSqlStatement(int pos, int line, int col, String sql, Delimiter delimiter, boolean canExecuteInTransaction, boolean batchable) {
        this.pos = pos;
        this.line = line;
        this.col = col;
        this.sql = sql;
        this.delimiter = delimiter;
        this.canExecuteInTransaction = canExecuteInTransaction;
        this.batchable = batchable;
    }

    @Override
    public final int getLineNumber() {
        return this.line;
    }

    @Override
    public String getDelimiter() {
        return this.delimiter.toString();
    }

    @Override
    public boolean canExecuteInTransaction() {
        return this.canExecuteInTransaction;
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate, SqlScriptExecutor sqlScriptExecutor, Configuration config) {
        return jdbcTemplate.executeStatement(this.sql);
    }

    @Generated
    public int getPos() {
        return this.pos;
    }

    @Generated
    public int getLine() {
        return this.line;
    }

    @Generated
    public int getCol() {
        return this.col;
    }

    @Override
    @Generated
    public String getSql() {
        return this.sql;
    }

    @Override
    @Generated
    public boolean isBatchable() {
        return this.batchable;
    }
}

