/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.strategy;

import bending.libraries.flywaydb.core.api.FlywayException;
import bending.libraries.flywaydb.core.internal.util.SqlCallable;
import java.sql.SQLException;

public class RetryStrategy {
    private static int numberOfRetries = 50;
    private static boolean unlimitedRetries;
    private int numberOfRetriesRemaining = numberOfRetries;

    public static void setNumberOfRetries(int retries) {
        numberOfRetries = retries;
        unlimitedRetries = retries < 0;
    }

    private boolean hasMoreRetries() {
        return unlimitedRetries || this.numberOfRetriesRemaining > 0;
    }

    private void nextRetry() {
        if (!unlimitedRetries) {
            --this.numberOfRetriesRemaining;
        }
    }

    private int nextWaitInMilliseconds() {
        return 1000;
    }

    public void doWithRetries(SqlCallable<Boolean> callable, String interruptionMessage, String retriesExceededMessage) throws SQLException {
        while (!callable.call().booleanValue()) {
            try {
                Thread.sleep(this.nextWaitInMilliseconds());
            }
            catch (InterruptedException e) {
                throw new FlywayException(interruptionMessage, e);
            }
            if (!this.hasMoreRetries()) {
                throw new FlywayException(retriesExceededMessage);
            }
            this.nextRetry();
        }
    }
}

