/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public class DockerUtils {
    private static final String NON_REDGATE_DOCKER = "Non-Redgate Docker";
    private static final String NON_REDGATE_CONTAINER = "Non-Redgate Container";
    private static final String UNKNOWN = "Unknown";
    private static final String NOT_CONTAINER = "Not container";
    private static final String REDGATE_DOCKER = "Redgate Docker";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getContainerType(Function<String, Path> getPath) {
        Path schedPath;
        String redgateDocker = System.getenv("REDGATE_DOCKER");
        if ("true".equals(redgateDocker)) {
            return REDGATE_DOCKER;
        }
        String osName = System.getProperty("os.name", "generic");
        if (osName.startsWith("Windows")) {
            return NOT_CONTAINER;
        }
        Path cgroupPath = getPath.apply("/proc/1/cgroup");
        if (Files.exists(cgroupPath, new LinkOption[0])) {
            try (Stream<String> lines = Files.lines(cgroupPath);){
                List<String> groups = lines.map(x -> x.split(":")[2]).toList();
                if (groups.stream().anyMatch(line -> line.startsWith("/docker"))) {
                    String string = NON_REDGATE_DOCKER;
                    return string;
                }
                if (groups.stream().anyMatch(line -> line.startsWith("/lxc"))) {
                    String string = NON_REDGATE_CONTAINER;
                    return string;
                }
            }
            catch (IOException e) {
                return UNKNOWN;
            }
        }
        if (!Files.exists(schedPath = getPath.apply("/proc/1/sched"), new LinkOption[0])) return UNKNOWN;
        try (Stream<String> lines = Files.lines(schedPath);){
            Optional<String> firstLine = lines.findFirst();
            if (!firstLine.isPresent()) return UNKNOWN;
            if (!firstLine.get().contains("init")) {
                if (!firstLine.get().contains("system")) return UNKNOWN;
            }
            String string = NOT_CONTAINER;
            return string;
        }
        catch (IOException e) {
            return UNKNOWN;
        }
    }

    public static boolean isContainer() {
        String containerType = DockerUtils.getContainerType(x$0 -> Paths.get(x$0, new String[0]));
        return !containerType.equals(NOT_CONTAINER) && !containerType.equals(UNKNOWN);
    }
}

