/*
 * Decompiled with CFR 0.152.
 */
package bending.libraries.flywaydb.core.internal.util;

import bending.libraries.flywaydb.core.api.FlywayException;
import bending.libraries.flywaydb.core.internal.util.FileUtils;
import bending.libraries.jackson.annotation.JsonInclude;
import bending.libraries.jackson.core.JsonFactory;
import bending.libraries.jackson.core.JsonParser;
import bending.libraries.jackson.core.JsonProcessingException;
import bending.libraries.jackson.core.JsonToken;
import bending.libraries.jackson.core.type.TypeReference;
import bending.libraries.jackson.databind.DeserializationFeature;
import bending.libraries.jackson.databind.JsonNode;
import bending.libraries.jackson.databind.MapperFeature;
import bending.libraries.jackson.databind.Module;
import bending.libraries.jackson.databind.ObjectMapper;
import bending.libraries.jackson.databind.SerializationFeature;
import bending.libraries.jackson.databind.json.JsonMapper;
import bending.libraries.jackson.databind.node.ArrayNode;
import bending.libraries.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class JsonUtils {
    public static String jsonToFile(String filename, Object json) {
        File file = new File(filename);
        FileUtils.createDirIfNotExists(file);
        try {
            JsonMapper mapper = JsonUtils.getJsonMapper();
            mapper.writeValue(file, json);
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            throw new FlywayException("Unable to write JSON to file: " + e.getMessage());
        }
    }

    public static String toJson(Object object) {
        try {
            return JsonUtils.getJsonMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new FlywayException("Unable to serialize object to JSON", e);
        }
    }

    public static JsonMapper getJsonMapper() {
        JsonMapper mapper = new JsonMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.configure(SerializationFeature.WRITE_DATES_WITH_ZONE_ID, true);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        mapper.configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public static <T> List<T> toList(String json) {
        try {
            return (List)JsonUtils.getJsonMapper().readValue(json, new TypeReference<List<T>>(){});
        }
        catch (JsonProcessingException e) {
            throw new FlywayException("Unable to parse JSON: " + json, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFromJson(String json, String key) {
        if (json == null) return null;
        if (json.isBlank()) {
            return null;
        }
        JsonFactory factory = new JsonFactory();
        try (JsonParser parser = factory.createParser(json);){
            block12: {
                parser.nextToken();
                while (parser.nextToken() != JsonToken.END_OBJECT) {
                    if (parser.currentToken() == null) return null;
                    if (parser.currentToken().isStructStart()) {
                        parser.skipChildren();
                        continue;
                    }
                    if (parser.currentToken() != JsonToken.FIELD_NAME || !key.equals(parser.currentName())) {
                        continue;
                    }
                    break block12;
                }
                return null;
            }
            parser.nextToken();
            String string = parser.getText();
            return string;
        }
        catch (IOException e) {
            throw new FlywayException("Unable to parse JSON: " + json, e);
        }
    }

    public static ArrayNode parseJsonArray(String json) {
        try {
            return (ArrayNode)JsonUtils.getJsonMapper().readTree(json);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to parse JSON: " + json, e);
        }
    }

    public static <T> T parseJson(String json, Class<T> clazz) {
        try {
            return JsonUtils.getJsonMapper().readValue(json, clazz);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to parse JSON: " + e.getMessage());
        }
    }

    public static <T> T parseJson(String json, TypeReference<T> typeReference) {
        try {
            return JsonUtils.getJsonMapper().readValue(json, typeReference);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to parse JSON: " + e.getMessage());
        }
    }

    public static List<String> getJsonSectionItems(String json, String sectionName) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree(json);
            JsonNode section = root.get(0).get(sectionName);
            ArrayList<String> fieldNames = new ArrayList<String>();
            if (section != null && section.isObject()) {
                Iterator<Map.Entry<String, JsonNode>> fields = section.fields();
                while (fields.hasNext()) {
                    Map.Entry<String, JsonNode> entry = fields.next();
                    fieldNames.add(entry.getKey());
                }
            }
            return fieldNames;
        }
        catch (Exception e) {
            throw new FlywayException("Unable to parse JSON: " + e.getMessage());
        }
    }

    @Generated
    private JsonUtils() {
    }
}

